package com.mastercard.masterpass.merchant;

import com.mastercard.masterpass.merchant.model.MerchantTransactions;

import com.mastercard.sdk.core.invoker.ApiClient;
import com.mastercard.sdk.core.util.ServiceRequest;
import com.mastercard.sdk.core.util.QueryParams;
import com.mastercard.sdk.core.exceptions.MasterpassErrorHandler;
import com.mastercard.sdk.core.ApiConfig;
import com.mastercard.sdk.core.MasterCardApiConfig;
import com.mastercard.masterpass.merchant.impl.APITrackerImpl;

public class PostbackApi {

 /**
   * Postback Service
   * <p>This is the final step of MasterPass transaction. MasterPass transaction is a service call from the merchant to MasterPass,communicating the result of the transaction (success or failure). This is a mandatory step. Abandoned transactions do not need to be reported. The &lt;TransactionId&gt; value should be the value from the &lt;TransactionId&gt; element of the Checkout XML returned in the Checkout request.</p>
   * @param merchantTransactions	the Merchant transactions details.
   * @return 	the MerchantTransactions.
   */
     public static MerchantTransactions create(MerchantTransactions merchantTransactions){
			return create( merchantTransactions, MasterCardApiConfig.config());
	}
 
 
 /**
   * Postback Service
   * <p>This is the final step of MasterPass transaction. MasterPass transaction is a service call from the merchant to MasterPass,communicating the result of the transaction (success or failure). This is a mandatory step. Abandoned transactions do not need to be reported. The &lt;TransactionId&gt; value should be the value from the &lt;TransactionId&gt; element of the Checkout XML returned in the Checkout request.</p>
   * @param merchantTransactions	the Merchant transactions details.
   * @param apiConfig  the ApiConfig object for multiple environment configuration 
   * @return 	the MerchantTransactions.
   */
     public static MerchantTransactions create(MerchantTransactions merchantTransactions, ApiConfig apiConfig){
   
	 String path = "/masterpass/v6/transaction";
	 ServiceRequest serviceRequest = new ServiceRequest();	
	 
	 
	 serviceRequest.requestBody(merchantTransactions);
	 
	 serviceRequest.contentType("application/xml");
	 
	 ApiClient apiClient = new ApiClient(apiConfig);
     apiClient.setApiTracker(new APITrackerImpl());
	 apiClient.setErrorHandler(new MasterpassErrorHandler());
	 
	 return apiClient.call(path,serviceRequest,"POST",MerchantTransactions.class);
	}
 
}
