package com.mastercard.masterpass.merchant;

import com.mastercard.masterpass.merchant.model.PrecheckoutDataResponse;
import com.mastercard.masterpass.merchant.model.PrecheckoutDataRequest;

import com.mastercard.sdk.core.invoker.ApiClient;
import com.mastercard.sdk.core.util.ServiceRequest;
import com.mastercard.sdk.core.util.QueryParams;
import com.mastercard.sdk.core.exceptions.MasterpassErrorHandler;
import com.mastercard.sdk.core.ApiConfig;
import com.mastercard.sdk.core.MasterCardApiConfig;
import com.mastercard.masterpass.merchant.impl.APITrackerImpl;

public class PrecheckoutDataApi {

 /**
   * Precheckout Data Service.
   * <p>MasterPass provides merchants with the ability to request a paired consumer&#39;s data (card alias, shipping addresses, reward program, and profile information) prior to the actual MasterPass checkout. This gives the merchant the ability to provide the consumer the opportunity to preselect their checkout options before completing the checkout. If, for any reason, the precheckout call gets rejected at MasterPass (merchant requests data that the consumer did not originally consent to, if the pairing has been deleted by the user, if the Long Access token has expired, and so on), the merchant has to request pairing again.</p>
   * @param oauthToken	the Long access token, which is used to retrieve precheckout data.
   * @param precheckoutDataRequest	the PreCheckout Data Request.
   * @return 	the PrecheckoutDataResponse.
   */
     public static PrecheckoutDataResponse create(String oauthToken, PrecheckoutDataRequest precheckoutDataRequest){
			return create( oauthToken,  precheckoutDataRequest, MasterCardApiConfig.config());
	}
 
 
 /**
   * Precheckout Data Service.
   * <p>MasterPass provides merchants with the ability to request a paired consumer&#39;s data (card alias, shipping addresses, reward program, and profile information) prior to the actual MasterPass checkout. This gives the merchant the ability to provide the consumer the opportunity to preselect their checkout options before completing the checkout. If, for any reason, the precheckout call gets rejected at MasterPass (merchant requests data that the consumer did not originally consent to, if the pairing has been deleted by the user, if the Long Access token has expired, and so on), the merchant has to request pairing again.</p>
   * @param oauthToken	the Long access token, which is used to retrieve precheckout data.
   * @param precheckoutDataRequest	the PreCheckout Data Request.
   * @param apiConfig  the ApiConfig object for multiple environment configuration 
   * @return 	the PrecheckoutDataResponse.
   */
     public static PrecheckoutDataResponse create(String oauthToken, PrecheckoutDataRequest precheckoutDataRequest, ApiConfig apiConfig){
   
	 String path = "/masterpass/v6/precheckout";
	 ServiceRequest serviceRequest = new ServiceRequest();	
	 
	 serviceRequest.header("oauth_token",oauthToken);
	 
	 serviceRequest.requestBody(precheckoutDataRequest);
	 
	 serviceRequest.contentType("application/xml");
	 
	 ApiClient apiClient = new ApiClient(apiConfig);
     apiClient.setApiTracker(new APITrackerImpl());
	 apiClient.setErrorHandler(new MasterpassErrorHandler());
	 
	 return apiClient.call(path,serviceRequest,"POST",PrecheckoutDataResponse.class);
	}
 
}
