package com.mastercard.masterpass.merchant;

import com.mastercard.masterpass.merchant.model.SessionKeySigningResponse;
import com.mastercard.masterpass.merchant.model.SessionKeySigningRequest;

import com.mastercard.sdk.core.invoker.ApiClient;
import com.mastercard.sdk.core.util.ServiceRequest;
import com.mastercard.sdk.core.util.QueryParams;
import com.mastercard.sdk.core.exceptions.MasterpassErrorHandler;
import com.mastercard.sdk.core.ApiConfig;
import com.mastercard.sdk.core.MasterCardApiConfig;
import com.mastercard.masterpass.merchant.impl.APITrackerImpl;

public class SessionKeySigningApi {

 /**
   * Session Key Signing
   * <p>Session Key Signing Android SDK.</p>
   * @param sessionKeySigningRequest	the Session Key Signing request.
   * @return 	the SessionKeySigningResponse.
   */
     public static SessionKeySigningResponse create(SessionKeySigningRequest sessionKeySigningRequest){
			return create( sessionKeySigningRequest, MasterCardApiConfig.config());
	}
 
 
 /**
   * Session Key Signing
   * <p>Session Key Signing Android SDK.</p>
   * @param sessionKeySigningRequest	the Session Key Signing request.
   * @param apiConfig  the ApiConfig object for multiple environment configuration 
   * @return 	the SessionKeySigningResponse.
   */
     public static SessionKeySigningResponse create(SessionKeySigningRequest sessionKeySigningRequest, ApiConfig apiConfig){
   
	 String path = "/masterpass/v6/sessionkeysigning";
	 ServiceRequest serviceRequest = new ServiceRequest();	
	 
	 
	 serviceRequest.requestBody(sessionKeySigningRequest);
	 
	 serviceRequest.contentType("application/xml");
	 
	 ApiClient apiClient = new ApiClient(apiConfig);
     apiClient.setApiTracker(new APITrackerImpl());
	 apiClient.setErrorHandler(new MasterpassErrorHandler());
	 
	 return apiClient.call(path,serviceRequest,"POST",SessionKeySigningResponse.class);
	}
 
}
