package com.mastercard.masterpass.merchant;

import com.mastercard.masterpass.merchant.model.ShoppingCartResponse;
import com.mastercard.masterpass.merchant.model.ShoppingCartRequest;

import com.mastercard.sdk.core.invoker.ApiClient;
import com.mastercard.sdk.core.util.ServiceRequest;
import com.mastercard.sdk.core.util.QueryParams;
import com.mastercard.sdk.core.exceptions.MasterpassErrorHandler;
import com.mastercard.sdk.core.ApiConfig;
import com.mastercard.sdk.core.MasterCardApiConfig;
import com.mastercard.masterpass.merchant.impl.APITrackerImpl;

public class ShoppingCartApi {

 /**
   * ShoppingCart service
   * <p>This service used to enables shopping cart data to be displayed to users as they proceed through the MasterPass login and checkout.Merchants must call the Shopping Cart service before invoking the MasterPass UI for checkout.</p>
   * @param shoppingCartRequest	the Shopping Cart Request.
   * @return 	the ShoppingCartResponse.
   */
     public static ShoppingCartResponse create(ShoppingCartRequest shoppingCartRequest){
			return create( shoppingCartRequest, MasterCardApiConfig.config());
	}
 
 
 /**
   * ShoppingCart service
   * <p>This service used to enables shopping cart data to be displayed to users as they proceed through the MasterPass login and checkout.Merchants must call the Shopping Cart service before invoking the MasterPass UI for checkout.</p>
   * @param shoppingCartRequest	the Shopping Cart Request.
   * @param apiConfig  the ApiConfig object for multiple environment configuration 
   * @return 	the ShoppingCartResponse.
   */
     public static ShoppingCartResponse create(ShoppingCartRequest shoppingCartRequest, ApiConfig apiConfig){
   
	 String path = "/masterpass/v6/shopping-cart";
	 ServiceRequest serviceRequest = new ServiceRequest();	
	 
	 
	 serviceRequest.requestBody(shoppingCartRequest);
	 
	 serviceRequest.contentType("application/xml");
	 
	 ApiClient apiClient = new ApiClient(apiConfig);
     apiClient.setApiTracker(new APITrackerImpl());
	 apiClient.setErrorHandler(new MasterpassErrorHandler());
	 
	 return apiClient.call(path,serviceRequest,"POST",ShoppingCartResponse.class);
	}
 
}
