package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.Types;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods to set acceptance options.
 **/
@Root(name = "AcceptanceOption")
@XmlRootElement (name = "AcceptanceOption")
public class AcceptanceOption   {
  
  @SerializedName("BrandId")
  @Element(name = "BrandId", required = false)
  private String brandId = null;
  
  @SerializedName("Types")
  @Element(name = "Types", required = false)
  private Types types = null;
  
  
  /**
   * Gets the brand id.
   * 
   * @return	the brand id.
   **/
  @XmlElement(name = "BrandId")
  public String getBrandId() {
    return brandId;
  }
  
  /**
  * Sets the brand id.
  *
  * @param brandId the brand id.
  */
    public AcceptanceOption brandId(String brandId) {
    this.brandId = brandId;
    return this;
  }
  
  
    

  
  /**
   * Gets the types.
   * 
   * @return	the types.
   **/
  @XmlElement(name = "Types")
  public Types getTypes() {
    return types;
  }
  
  /**
  * Sets the types.
  *
  * @param types the types.
  */
    public AcceptanceOption types(Types types) {
    this.types = types;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AcceptanceOption acceptanceOption = (AcceptanceOption) o;
    return Objects.equals(brandId, acceptanceOption.brandId) &&
        Objects.equals(types, acceptanceOption.types);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(brandId, types);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AcceptanceOption {\n");
    
    sb.append("    brandId: ").append(toIndentedString(brandId)).append("\n");
    sb.append("    types: ").append(toIndentedString(types)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


