package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods to set different authentication options required during DSRP.
 **/
@Root(name = "AuthenticationOptions")
@XmlRootElement (name = "AuthenticationOptions")
public class AuthenticationOptions   {
  
  @SerializedName("AuthenticateMethod")
  @Element(name = "AuthenticateMethod", required = false)
  private String authenticateMethod = null;
  
  @SerializedName("CardEnrollmentMethod")
  @Element(name = "CardEnrollmentMethod", required = false)
  private String cardEnrollmentMethod = null;
  
  @SerializedName("CAvv")
  @Element(name = "CAvv", required = false)
  private String cAvv = null;
  
  @SerializedName("EciFlag")
  @Element(name = "EciFlag", required = false)
  private String eciFlag = null;
  
  @SerializedName("MasterCardAssignedID")
  @Element(name = "MasterCardAssignedID", required = false)
  private String masterCardAssignedID = null;
  
  @SerializedName("PaResStatus")
  @Element(name = "PaResStatus", required = false)
  private String paResStatus = null;
  
  @SerializedName("SCEnrollmentStatus")
  @Element(name = "SCEnrollmentStatus", required = false)
  private String sCEnrollmentStatus = null;
  
  @SerializedName("SignatureVerification")
  @Element(name = "SignatureVerification", required = false)
  private String signatureVerification = null;
  
  @SerializedName("Xid")
  @Element(name = "Xid", required = false)
  private String xid = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the method used to authenticate the cardholder at checkout. Valid values are MERCHANT ONLY, 3DS and No Authentication.
   * 
   * @return	the method used to authenticate the cardholder at checkout. Valid values are MERCHANT ONLY, 3DS and No Authentication.
   **/
  @XmlElement(name = "AuthenticateMethod")
  public String getAuthenticateMethod() {
    return authenticateMethod;
  }
  
  /**
  * Sets the method used to authenticate the cardholder at checkout. Valid values are MERCHANT ONLY, 3DS and No Authentication.
  *
  * @param authenticateMethod the method used to authenticate the cardholder at checkout. Valid values are MERCHANT ONLY, 3DS and No Authentication.
  */
    public AuthenticationOptions authenticateMethod(String authenticateMethod) {
    this.authenticateMethod = authenticateMethod;
    return this;
  }
  
  
    

  
  /**
   * Gets the method by which the card was added to the wallet. Valid values are: Manual Direct Provisioned 3DS Manual NFC Tap.
   * 
   * @return	the method by which the card was added to the wallet. Valid values are: Manual Direct Provisioned 3DS Manual NFC Tap.
   **/
  @XmlElement(name = "CardEnrollmentMethod")
  public String getCardEnrollmentMethod() {
    return cardEnrollmentMethod;
  }
  
  /**
  * Sets the method by which the card was added to the wallet. Valid values are: Manual Direct Provisioned 3DS Manual NFC Tap.
  *
  * @param cardEnrollmentMethod the method by which the card was added to the wallet. Valid values are: Manual Direct Provisioned 3DS Manual NFC Tap.
  */
    public AuthenticationOptions cardEnrollmentMethod(String cardEnrollmentMethod) {
    this.cardEnrollmentMethod = cardEnrollmentMethod;
    return this;
  }
  
  
    

  
  /**
   * Gets the (CAVV) Cardholder Authentication Verification Value generated by card issuer upon successful authentication of the cardholder. This must be passed in the authorization message.
   * 
   * @return	the (CAVV) Cardholder Authentication Verification Value generated by card issuer upon successful authentication of the cardholder. This must be passed in the authorization message.
   **/
  @XmlElement(name = "CAvv")
  public String getCAvv() {
    return cAvv;
  }
  
  /**
  * Sets the (CAVV) Cardholder Authentication Verification Value generated by card issuer upon successful authentication of the cardholder. This must be passed in the authorization message.
  *
  * @param cAvv the (CAVV) Cardholder Authentication Verification Value generated by card issuer upon successful authentication of the cardholder. This must be passed in the authorization message.
  */
    public AuthenticationOptions cAvv(String cAvv) {
    this.cAvv = cAvv;
    return this;
  }
  
  
    

  
  /**
   * Gets the Electronic commerce indicator (ECI) flag. Possible values are as follows: MasterCard: 00:No Authentication 01:Attempts (Card Issuer Liability) 02:Authenticated by ACS (Card Issuer Liability) 03:Maestro (MARP) 05:Risk Based Authentication (Issuer, not in use) 06:Risk Based Authentication (Merchant, not in use) Visa: 05:Authenticated (Card Issuer Liability) 06:Attempts (Card Issuer Liability) 07:No 3DS Authentication (Merchant Liability)
   * 
   * @return	the Electronic commerce indicator (ECI) flag. Possible values are as follows: MasterCard: 00:No Authentication 01:Attempts (Card Issuer Liability) 02:Authenticated by ACS (Card Issuer Liability) 03:Maestro (MARP) 05:Risk Based Authentication (Issuer, not in use) 06:Risk Based Authentication (Merchant, not in use) Visa: 05:Authenticated (Card Issuer Liability) 06:Attempts (Card Issuer Liability) 07:No 3DS Authentication (Merchant Liability)
   **/
  @XmlElement(name = "EciFlag")
  public String getEciFlag() {
    return eciFlag;
  }
  
  /**
  * Sets the Electronic commerce indicator (ECI) flag. Possible values are as follows: MasterCard: 00:No Authentication 01:Attempts (Card Issuer Liability) 02:Authenticated by ACS (Card Issuer Liability) 03:Maestro (MARP) 05:Risk Based Authentication (Issuer, not in use) 06:Risk Based Authentication (Merchant, not in use) Visa: 05:Authenticated (Card Issuer Liability) 06:Attempts (Card Issuer Liability) 07:No 3DS Authentication (Merchant Liability)
  *
  * @param eciFlag the Electronic commerce indicator (ECI) flag. Possible values are as follows: MasterCard: 00:No Authentication 01:Attempts (Card Issuer Liability) 02:Authenticated by ACS (Card Issuer Liability) 03:Maestro (MARP) 05:Risk Based Authentication (Issuer, not in use) 06:Risk Based Authentication (Merchant, not in use) Visa: 05:Authenticated (Card Issuer Liability) 06:Attempts (Card Issuer Liability) 07:No 3DS Authentication (Merchant Liability)
  */
    public AuthenticationOptions eciFlag(String eciFlag) {
    this.eciFlag = eciFlag;
    return this;
  }
  
  
    

  
  /**
   * Gets the value assigned by MasterCard and represents programs associated directly with Maestro cards. This field should be supplied in the authorization request by the merchant.
   * 
   * @return	the value assigned by MasterCard and represents programs associated directly with Maestro cards. This field should be supplied in the authorization request by the merchant.
   **/
  @XmlElement(name = "MasterCardAssignedID")
  public String getMasterCardAssignedID() {
    return masterCardAssignedID;
  }
  
  /**
  * Sets the value assigned by MasterCard and represents programs associated directly with Maestro cards. This field should be supplied in the authorization request by the merchant.
  *
  * @param masterCardAssignedID the value assigned by MasterCard and represents programs associated directly with Maestro cards. This field should be supplied in the authorization request by the merchant.
  */
    public AuthenticationOptions masterCardAssignedID(String masterCardAssignedID) {
    this.masterCardAssignedID = masterCardAssignedID;
    return this;
  }
  
  
    

  
  /**
   * Gets the message formatted, digitally signed, and sent from the ACS (issuer) to the MPI providing the results of the issuer's MasterCard SecureCode/Verified by Visa cardholder authentication. Possible values are: Y-The card was successfully authenticated via 3-D Secure A-signifies that either (a) the transaction was successfully authenticated via a 3-D Secure attempts transaction or (b)the cardholder was prompted to activate 3-D Secure during shopping but declined (Visa). U-Authentication results were unavailable.
   * 
   * @return	the message formatted, digitally signed, and sent from the ACS (issuer) to the MPI providing the results of the issuer's MasterCard SecureCode/Verified by Visa cardholder authentication. Possible values are: Y-The card was successfully authenticated via 3-D Secure A-signifies that either (a) the transaction was successfully authenticated via a 3-D Secure attempts transaction or (b)the cardholder was prompted to activate 3-D Secure during shopping but declined (Visa). U-Authentication results were unavailable.
   **/
  @XmlElement(name = "PaResStatus")
  public String getPaResStatus() {
    return paResStatus;
  }
  
  /**
  * Sets the message formatted, digitally signed, and sent from the ACS (issuer) to the MPI providing the results of the issuer's MasterCard SecureCode/Verified by Visa cardholder authentication. Possible values are: Y-The card was successfully authenticated via 3-D Secure A-signifies that either (a) the transaction was successfully authenticated via a 3-D Secure attempts transaction or (b)the cardholder was prompted to activate 3-D Secure during shopping but declined (Visa). U-Authentication results were unavailable.
  *
  * @param paResStatus the message formatted, digitally signed, and sent from the ACS (issuer) to the MPI providing the results of the issuer's MasterCard SecureCode/Verified by Visa cardholder authentication. Possible values are: Y-The card was successfully authenticated via 3-D Secure A-signifies that either (a) the transaction was successfully authenticated via a 3-D Secure attempts transaction or (b)the cardholder was prompted to activate 3-D Secure during shopping but declined (Visa). U-Authentication results were unavailable.
  */
    public AuthenticationOptions paResStatus(String paResStatus) {
    this.paResStatus = paResStatus;
    return this;
  }
  
  
    

  
  /**
   * Gets the MasterCard SecureCode Enrollment Status. Indicates if the issuer of the card supports payer authentication for this card. Possible values are as follows: Y-The card is eligible for 3-D Secure authentication. N-The card is not eligible for 3-D Secure authentication. U-Lookup of the card's 3-D Secure eligibility status was either unavailable, or the card is inapplicable (for example, prepaid cards).
   * 
   * @return	the MasterCard SecureCode Enrollment Status. Indicates if the issuer of the card supports payer authentication for this card. Possible values are as follows: Y-The card is eligible for 3-D Secure authentication. N-The card is not eligible for 3-D Secure authentication. U-Lookup of the card's 3-D Secure eligibility status was either unavailable, or the card is inapplicable (for example, prepaid cards).
   **/
  @XmlElement(name = "SCEnrollmentStatus")
  public String getSCEnrollmentStatus() {
    return sCEnrollmentStatus;
  }
  
  /**
  * Sets the MasterCard SecureCode Enrollment Status. Indicates if the issuer of the card supports payer authentication for this card. Possible values are as follows: Y-The card is eligible for 3-D Secure authentication. N-The card is not eligible for 3-D Secure authentication. U-Lookup of the card's 3-D Secure eligibility status was either unavailable, or the card is inapplicable (for example, prepaid cards).
  *
  * @param sCEnrollmentStatus the MasterCard SecureCode Enrollment Status. Indicates if the issuer of the card supports payer authentication for this card. Possible values are as follows: Y-The card is eligible for 3-D Secure authentication. N-The card is not eligible for 3-D Secure authentication. U-Lookup of the card's 3-D Secure eligibility status was either unavailable, or the card is inapplicable (for example, prepaid cards).
  */
    public AuthenticationOptions sCEnrollmentStatus(String sCEnrollmentStatus) {
    this.sCEnrollmentStatus = sCEnrollmentStatus;
    return this;
  }
  
  
    

  
  /**
   * Gets the signature verification. Possible values are as follows: Y-Indicates that the signature of the PaRes has been validated successfully and the message contents can be trusted. N-Indicates that for a variety of reasons (tampering, certificate expiration, and so on) the PaRes could not be validated, and the result should not be trusted.
   * 
   * @return	the signature verification. Possible values are as follows: Y-Indicates that the signature of the PaRes has been validated successfully and the message contents can be trusted. N-Indicates that for a variety of reasons (tampering, certificate expiration, and so on) the PaRes could not be validated, and the result should not be trusted.
   **/
  @XmlElement(name = "SignatureVerification")
  public String getSignatureVerification() {
    return signatureVerification;
  }
  
  /**
  * Sets the signature verification. Possible values are as follows: Y-Indicates that the signature of the PaRes has been validated successfully and the message contents can be trusted. N-Indicates that for a variety of reasons (tampering, certificate expiration, and so on) the PaRes could not be validated, and the result should not be trusted.
  *
  * @param signatureVerification the signature verification. Possible values are as follows: Y-Indicates that the signature of the PaRes has been validated successfully and the message contents can be trusted. N-Indicates that for a variety of reasons (tampering, certificate expiration, and so on) the PaRes could not be validated, and the result should not be trusted.
  */
    public AuthenticationOptions signatureVerification(String signatureVerification) {
    this.signatureVerification = signatureVerification;
    return this;
  }
  
  
    

  
  /**
   * Gets the transaction identifier resulting from authentication processing.
   * 
   * @return	the transaction identifier resulting from authentication processing.
   **/
  @XmlElement(name = "Xid")
  public String getXid() {
    return xid;
  }
  
  /**
  * Sets the transaction identifier resulting from authentication processing.
  *
  * @param xid the transaction identifier resulting from authentication processing.
  */
    public AuthenticationOptions xid(String xid) {
    this.xid = xid;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public AuthenticationOptions extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthenticationOptions authenticationOptions = (AuthenticationOptions) o;
    return Objects.equals(authenticateMethod, authenticationOptions.authenticateMethod) &&
        Objects.equals(cardEnrollmentMethod, authenticationOptions.cardEnrollmentMethod) &&
        Objects.equals(cAvv, authenticationOptions.cAvv) &&
        Objects.equals(eciFlag, authenticationOptions.eciFlag) &&
        Objects.equals(masterCardAssignedID, authenticationOptions.masterCardAssignedID) &&
        Objects.equals(paResStatus, authenticationOptions.paResStatus) &&
        Objects.equals(sCEnrollmentStatus, authenticationOptions.sCEnrollmentStatus) &&
        Objects.equals(signatureVerification, authenticationOptions.signatureVerification) &&
        Objects.equals(xid, authenticationOptions.xid) &&
        Objects.equals(extensionPoint, authenticationOptions.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(authenticateMethod, cardEnrollmentMethod, cAvv, eciFlag, masterCardAssignedID, paResStatus, sCEnrollmentStatus, signatureVerification, xid, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthenticationOptions {\n");
    
    sb.append("    authenticateMethod: ").append(toIndentedString(authenticateMethod)).append("\n");
    sb.append("    cardEnrollmentMethod: ").append(toIndentedString(cardEnrollmentMethod)).append("\n");
    sb.append("    cAvv: ").append(toIndentedString(cAvv)).append("\n");
    sb.append("    eciFlag: ").append(toIndentedString(eciFlag)).append("\n");
    sb.append("    masterCardAssignedID: ").append(toIndentedString(masterCardAssignedID)).append("\n");
    sb.append("    paResStatus: ").append(toIndentedString(paResStatus)).append("\n");
    sb.append("    sCEnrollmentStatus: ").append(toIndentedString(sCEnrollmentStatus)).append("\n");
    sb.append("    signatureVerification: ").append(toIndentedString(signatureVerification)).append("\n");
    sb.append("    xid: ").append(toIndentedString(xid)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


