package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.Address;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods to get consumer card brand information.
 **/
@Root(name = "BaseCard")
@XmlRootElement (name = "BaseCard")
public class BaseCard   {
  
  @SerializedName("BrandId")
  @Element(name = "BrandId", required = false)
  private String brandId = null;
  
  @SerializedName("BrandName")
  @Element(name = "BrandName", required = false)
  private String brandName = null;
  
  @SerializedName("BillingAddress")
  @Element(name = "BillingAddress", required = false)
  private Address billingAddress = null;
  
  @SerializedName("CardHolderName")
  @Element(name = "CardHolderName")
  private String cardHolderName = null;
  
  @SerializedName("ExpiryMonth")
  @Element(name = "ExpiryMonth", required = false)
  private Integer expiryMonth = null;
  
  @SerializedName("ExpiryYear")
  @Element(name = "ExpiryYear", required = false)
  private Integer expiryYear = null;
  
  
  /**
   * Gets the card brand id, for example, master for MasterCard.
   * 
   * @return	the card brand id, for example, master for MasterCard.
   **/
  @XmlElement(name = "BrandId")
  public String getBrandId() {
    return brandId;
  }
  
  /**
  * Sets the card brand id, for example, master for MasterCard.
  *
  * @param brandId the card brand id, for example, master for MasterCard.
  */
    public BaseCard brandId(String brandId) {
    this.brandId = brandId;
    return this;
  }
  
  
    

  
  /**
   * Gets the card brand name, for example, MasterCard.
   * 
   * @return	the card brand name, for example, MasterCard.
   **/
  @XmlElement(name = "BrandName")
  public String getBrandName() {
    return brandName;
  }
  
  /**
  * Sets the card brand name, for example, MasterCard.
  *
  * @param brandName the card brand name, for example, MasterCard.
  */
    public BaseCard brandName(String brandName) {
    this.brandName = brandName;
    return this;
  }
  
  
    

  
  /**
   * Gets the billing address for the card holder.
   * 
   * @return	the billing address for the card holder.
   **/
  @XmlElement(name = "BillingAddress")
  public Address getBillingAddress() {
    return billingAddress;
  }
  
  /**
  * Sets the billing address for the card holder.
  *
  * @param billingAddress the billing address for the card holder.
  */
    public BaseCard billingAddress(Address billingAddress) {
    this.billingAddress = billingAddress;
    return this;
  }
  
  
    

  
  /**
   * Gets the cardholder name.
   * 
   * @return	the cardholder name.
   **/
  @XmlElement(name = "CardHolderName")
  public String getCardHolderName() {
    return cardHolderName;
  }
  
  /**
  * Sets the cardholder name.
  *
  * @param cardHolderName the cardholder name.
  */
    public BaseCard cardHolderName(String cardHolderName) {
    this.cardHolderName = cardHolderName;
    return this;
  }
  
  
    

  
  /**
   * Gets the expiration month displayed on the payment card.
   * 
   * @return	the expiration month displayed on the payment card.
   **/
  @XmlElement(name = "ExpiryMonth")
  public Integer getExpiryMonth() {
    return expiryMonth;
  }
  
  /**
  * Sets the expiration month displayed on the payment card.
  *
  * @param expiryMonth the expiration month displayed on the payment card.
  */
    public BaseCard expiryMonth(Integer expiryMonth) {
    this.expiryMonth = expiryMonth;
    return this;
  }
  
  
    

  
  /**
   * Gets the expiration year displayed on the payment card.
   * 
   * @return	the expiration year displayed on the payment card.
   **/
  @XmlElement(name = "ExpiryYear")
  public Integer getExpiryYear() {
    return expiryYear;
  }
  
  /**
  * Sets the expiration year displayed on the payment card.
  *
  * @param expiryYear the expiration year displayed on the payment card.
  */
    public BaseCard expiryYear(Integer expiryYear) {
    this.expiryYear = expiryYear;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BaseCard baseCard = (BaseCard) o;
    return Objects.equals(brandId, baseCard.brandId) &&
        Objects.equals(brandName, baseCard.brandName) &&
        Objects.equals(billingAddress, baseCard.billingAddress) &&
        Objects.equals(cardHolderName, baseCard.cardHolderName) &&
        Objects.equals(expiryMonth, baseCard.expiryMonth) &&
        Objects.equals(expiryYear, baseCard.expiryYear);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(brandId, brandName, billingAddress, cardHolderName, expiryMonth, expiryYear);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BaseCard {\n");
    
    sb.append("    brandId: ").append(toIndentedString(brandId)).append("\n");
    sb.append("    brandName: ").append(toIndentedString(brandName)).append("\n");
    sb.append("    billingAddress: ").append(toIndentedString(billingAddress)).append("\n");
    sb.append("    cardHolderName: ").append(toIndentedString(cardHolderName)).append("\n");
    sb.append("    expiryMonth: ").append(toIndentedString(expiryMonth)).append("\n");
    sb.append("    expiryYear: ").append(toIndentedString(expiryYear)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


