package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.AuthenticationOptions;
import com.mastercard.masterpass.merchant.model.Card;
import com.mastercard.masterpass.merchant.model.CheckoutExtension;
import com.mastercard.masterpass.merchant.model.Contact;
import com.mastercard.masterpass.merchant.model.RewardProgram;
import com.mastercard.masterpass.merchant.model.ShippingAddress;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains various methods for to set the different values like card, contact, shipping address, authentication options, reward program details.
 **/
@Root(name = "Checkout")
@XmlRootElement (name = "Checkout")
public class Checkout   {
  
  @SerializedName("Card")
  @Element(name = "Card", required = false)
  private Card card = null;
  
  @SerializedName("TransactionId")
  @Element(name = "TransactionId", required = false)
  private String transactionId = null;
  
  @SerializedName("Contact")
  @Element(name = "Contact", required = false)
  private Contact contact = null;
  
  @SerializedName("ShippingAddress")
  @Element(name = "ShippingAddress", required = false)
  private ShippingAddress shippingAddress = null;
  
  @SerializedName("AuthenticationOptions")
  @Element(name = "AuthenticationOptions", required = false)
  private AuthenticationOptions authenticationOptions = null;
  
  @SerializedName("RewardProgram")
  @Element(name = "RewardProgram", required = false)
  private RewardProgram rewardProgram = null;
  
  @SerializedName("WalletID")
  @Element(name = "WalletID", required = false)
  private String walletID = null;
  
  @SerializedName("PreCheckoutTransactionId")
  @Element(name = "PreCheckoutTransactionId", required = false)
  private String preCheckoutTransactionId = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private CheckoutExtension extensionPoint = null;
  
  
  /**
   * Gets the card details.
   * 
   * @return	the card details.
   **/
  @XmlElement(name = "Card")
  public Card getCard() {
    return card;
  }
  
  /**
  * Sets the card details.
  *
  * @param card the card details.
  */
    public Checkout card(Card card) {
    this.card = card;
    return this;
  }
  
  
    

  
  /**
   * Gets the transaction id.
   * 
   * @return	the transaction id.
   **/
  @XmlElement(name = "TransactionId")
  public String getTransactionId() {
    return transactionId;
  }
  
  /**
  * Sets the transaction id.
  *
  * @param transactionId the transaction id.
  */
    public Checkout transactionId(String transactionId) {
    this.transactionId = transactionId;
    return this;
  }
  
  
    

  
  /**
   * Gets the contact details.
   * 
   * @return	the contact details.
   **/
  @XmlElement(name = "Contact")
  public Contact getContact() {
    return contact;
  }
  
  /**
  * Sets the contact details.
  *
  * @param contact the contact details.
  */
    public Checkout contact(Contact contact) {
    this.contact = contact;
    return this;
  }
  
  
    

  
  /**
   * Gets the shipping address details.
   * 
   * @return	the shipping address details.
   **/
  @XmlElement(name = "ShippingAddress")
  public ShippingAddress getShippingAddress() {
    return shippingAddress;
  }
  
  /**
  * Sets the shipping address details.
  *
  * @param shippingAddress the shipping address details.
  */
    public Checkout shippingAddress(ShippingAddress shippingAddress) {
    this.shippingAddress = shippingAddress;
    return this;
  }
  
  
    

  
  /**
   * Gets the authentication options.
   * 
   * @return	the authentication options.
   **/
  @XmlElement(name = "AuthenticationOptions")
  public AuthenticationOptions getAuthenticationOptions() {
    return authenticationOptions;
  }
  
  /**
  * Sets the authentication options.
  *
  * @param authenticationOptions the authentication options.
  */
    public Checkout authenticationOptions(AuthenticationOptions authenticationOptions) {
    this.authenticationOptions = authenticationOptions;
    return this;
  }
  
  
    

  
  /**
   * Gets the reward program details.
   * 
   * @return	the reward program details.
   **/
  @XmlElement(name = "RewardProgram")
  public RewardProgram getRewardProgram() {
    return rewardProgram;
  }
  
  /**
  * Sets the reward program details.
  *
  * @param rewardProgram the reward program details.
  */
    public Checkout rewardProgram(RewardProgram rewardProgram) {
    this.rewardProgram = rewardProgram;
    return this;
  }
  
  
    

  
  /**
   * Gets the value which helps to identify origin wallet.
   * 
   * @return	the value which helps to identify origin wallet.
   **/
  @XmlElement(name = "WalletID")
  public String getWalletID() {
    return walletID;
  }
  
  /**
  * Sets the value which helps to identify origin wallet.
  *
  * @param walletID the value which helps to identify origin wallet.
  */
    public Checkout walletID(String walletID) {
    this.walletID = walletID;
    return this;
  }
  
  
    

  
  /**
   * Gets the ID associated with the PreCheckout Transaction.
   * 
   * @return	the ID associated with the PreCheckout Transaction.
   **/
  @XmlElement(name = "PreCheckoutTransactionId")
  public String getPreCheckoutTransactionId() {
    return preCheckoutTransactionId;
  }
  
  /**
  * Sets the ID associated with the PreCheckout Transaction.
  *
  * @param preCheckoutTransactionId the ID associated with the PreCheckout Transaction.
  */
    public Checkout preCheckoutTransactionId(String preCheckoutTransactionId) {
    this.preCheckoutTransactionId = preCheckoutTransactionId;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public CheckoutExtension getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public Checkout extensionPoint(CheckoutExtension extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Checkout checkout = (Checkout) o;
    return Objects.equals(card, checkout.card) &&
        Objects.equals(transactionId, checkout.transactionId) &&
        Objects.equals(contact, checkout.contact) &&
        Objects.equals(shippingAddress, checkout.shippingAddress) &&
        Objects.equals(authenticationOptions, checkout.authenticationOptions) &&
        Objects.equals(rewardProgram, checkout.rewardProgram) &&
        Objects.equals(walletID, checkout.walletID) &&
        Objects.equals(preCheckoutTransactionId, checkout.preCheckoutTransactionId) &&
        Objects.equals(extensionPoint, checkout.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(card, transactionId, contact, shippingAddress, authenticationOptions, rewardProgram, walletID, preCheckoutTransactionId, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Checkout {\n");
    
    sb.append("    card: ").append(toIndentedString(card)).append("\n");
    sb.append("    transactionId: ").append(toIndentedString(transactionId)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    shippingAddress: ").append(toIndentedString(shippingAddress)).append("\n");
    sb.append("    authenticationOptions: ").append(toIndentedString(authenticationOptions)).append("\n");
    sb.append("    rewardProgram: ").append(toIndentedString(rewardProgram)).append("\n");
    sb.append("    walletID: ").append(toIndentedString(walletID)).append("\n");
    sb.append("    preCheckoutTransactionId: ").append(toIndentedString(preCheckoutTransactionId)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


