package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.DSRP;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



@Root(name = "CheckoutDSRP")
@XmlRootElement (name = "CheckoutDSRP")
public class CheckoutDSRP   {
  
  @SerializedName("Eci")
  @Element(name = "Eci", required = false)
  private String eci = null;
  
  @SerializedName("DSRPDataType")
  @Element(name = "DSRPDataType")
  private String dSRPDataType = null;
  
  @SerializedName("DSRPData")
  @Element(name = "DSRPData")
  private String dSRPData = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  @SerializedName("UnpredictableNumber")
  @Element(name = "UnpredictableNumber", required = false)
  private String unpredictableNumber = null;
  
  
  /**
   * Gets the electronic commerce indicator (ECI) value (DE 48 SE 42 position 3). Present only when DSRP data type is UCAF. For MasterCard brand cards, value is: 02Authenticated by ACS (Card Issuer Liability)
   * 
   * @return	the electronic commerce indicator (ECI) value (DE 48 SE 42 position 3). Present only when DSRP data type is UCAF. For MasterCard brand cards, value is: 02Authenticated by ACS (Card Issuer Liability)
   **/
  @XmlElement(name = "Eci")
  public String getEci() {
    return eci;
  }
  
  /**
  * Sets the electronic commerce indicator (ECI) value (DE 48 SE 42 position 3). Present only when DSRP data type is UCAF. For MasterCard brand cards, value is: 02Authenticated by ACS (Card Issuer Liability)
  *
  * @param eci the electronic commerce indicator (ECI) value (DE 48 SE 42 position 3). Present only when DSRP data type is UCAF. For MasterCard brand cards, value is: 02Authenticated by ACS (Card Issuer Liability)
  */
    public CheckoutDSRP eci(String eci) {
    this.eci = eci;
    return this;
  }
  
  
    

  
  /**
   * Gets the type of cryptogram generated by the consumers MasterPass wallet. MasterPass passes the most secure selection (ICC) if the merchant or service provider has indicated they can accept both types (UCAF, ICC).
   * 
   * @return	the type of cryptogram generated by the consumers MasterPass wallet. MasterPass passes the most secure selection (ICC) if the merchant or service provider has indicated they can accept both types (UCAF, ICC).
   **/
  @XmlElement(name = "DSRPDataType")
  public String getDSRPDataType() {
    return dSRPDataType;
  }
  
  /**
  * Sets the type of cryptogram generated by the consumers MasterPass wallet. MasterPass passes the most secure selection (ICC) if the merchant or service provider has indicated they can accept both types (UCAF, ICC).
  *
  * @param dSRPDataType the type of cryptogram generated by the consumers MasterPass wallet. MasterPass passes the most secure selection (ICC) if the merchant or service provider has indicated they can accept both types (UCAF, ICC).
  */
    public CheckoutDSRP dSRPDataType(String dSRPDataType) {
    this.dSRPDataType = dSRPDataType;
    return this;
  }
  
  
    

  
  /**
   * Gets the DSRP cryptogram generated by the consumers MasterPass wallet.
   * 
   * @return	the DSRP cryptogram generated by the consumers MasterPass wallet.
   **/
  @XmlElement(name = "DSRPData")
  public String getDSRPData() {
    return dSRPData;
  }
  
  /**
  * Sets the DSRP cryptogram generated by the consumers MasterPass wallet.
  *
  * @param dSRPData the DSRP cryptogram generated by the consumers MasterPass wallet.
  */
    public CheckoutDSRP dSRPData(String dSRPData) {
    this.dSRPData = dSRPData;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public CheckoutDSRP extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Gets the encoded EMV-quality random number generated by either the merchant or MasterPass.
   * 
   * @return	the encoded EMV-quality random number generated by either the merchant or MasterPass.
   **/
  @XmlElement(name = "UnpredictableNumber")
  public String getUnpredictableNumber() {
    return unpredictableNumber;
  }
  
  /**
  * Sets the encoded EMV-quality random number generated by either the merchant or MasterPass.
  *
  * @param unpredictableNumber the encoded EMV-quality random number generated by either the merchant or MasterPass.
  */
    public CheckoutDSRP unpredictableNumber(String unpredictableNumber) {
    this.unpredictableNumber = unpredictableNumber;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CheckoutDSRP checkoutDSRP = (CheckoutDSRP) o;
    return Objects.equals(eci, checkoutDSRP.eci) &&
        Objects.equals(dSRPDataType, checkoutDSRP.dSRPDataType) &&
        Objects.equals(dSRPData, checkoutDSRP.dSRPData) &&
        Objects.equals(extensionPoint, checkoutDSRP.extensionPoint) &&
        Objects.equals(unpredictableNumber, checkoutDSRP.unpredictableNumber);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(eci, dSRPDataType, dSRPData, extensionPoint, unpredictableNumber);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CheckoutDSRP {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    eci: ").append(toIndentedString(eci)).append("\n");
    sb.append("    dSRPDataType: ").append(toIndentedString(dSRPDataType)).append("\n");
    sb.append("    dSRPData: ").append(toIndentedString(dSRPData)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("    unpredictableNumber: ").append(toIndentedString(unpredictableNumber)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


