package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.DSRPOptions;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods require to set DSRP extension for merchant initialization request during DSRP.
 **/
@Root(name = "DSRPExtension")
@XmlRootElement (name = "DSRPExtension")
public class DSRPExtension   {
  
  @SerializedName("DSRPOptions")
  @Element(name = "DSRPOptions")
  private DSRPOptions dSRPOptions = null;
  
  @SerializedName("UnpredictableNumber")
  @Element(name = "UnpredictableNumber", required = false)
  private String unpredictableNumber = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the DSRP options details.
   * 
   * @return	the DSRP options details.
   **/
  @XmlElement(name = "DSRPOptions")
  public DSRPOptions getDSRPOptions() {
    return dSRPOptions;
  }
  
  /**
  * Sets the DSRP options details.
  *
  * @param dSRPOptions the DSRP options details.
  */
    public DSRPExtension dSRPOptions(DSRPOptions dSRPOptions) {
    this.dSRPOptions = dSRPOptions;
    return this;
  }
  
  
    

  
  /**
   * Gets the unpredictable number. EMVquality random number generated by the merchant, service provider, or,if null,by MasterPass and Base64 encoded
   * 
   * @return	the unpredictable number. EMVquality random number generated by the merchant, service provider, or,if null,by MasterPass and Base64 encoded
   **/
  @XmlElement(name = "UnpredictableNumber")
  public String getUnpredictableNumber() {
    return unpredictableNumber;
  }
  
  /**
  * Sets the unpredictable number. EMVquality random number generated by the merchant, service provider, or,if null,by MasterPass and Base64 encoded
  *
  * @param unpredictableNumber the unpredictable number. EMVquality random number generated by the merchant, service provider, or,if null,by MasterPass and Base64 encoded
  */
    public DSRPExtension unpredictableNumber(String unpredictableNumber) {
    this.unpredictableNumber = unpredictableNumber;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public DSRPExtension extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DSRPExtension dSRPExtension = (DSRPExtension) o;
    return Objects.equals(dSRPOptions, dSRPExtension.dSRPOptions) &&
        Objects.equals(unpredictableNumber, dSRPExtension.unpredictableNumber) &&
        Objects.equals(extensionPoint, dSRPExtension.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(dSRPOptions, unpredictableNumber, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DSRPExtension {\n");
    
    sb.append("    dSRPOptions: ").append(toIndentedString(dSRPOptions)).append("\n");
    sb.append("    unpredictableNumber: ").append(toIndentedString(unpredictableNumber)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


