package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import com.mastercard.masterpass.merchant.model.Option;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.*;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods require to set DSRP options for merchant initialization request during DSRP.
 **/
@Root(name = "DSRPOptions")
@XmlRootElement (name = "DSRPOptions")
public class DSRPOptions   {
  
  @SerializedName("Option")
  @ElementList(name = "Option" , inline = true, entry = "Option", required = false)
  private List<Option> option = new ArrayList<Option>();
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the DSRP option.
   * 
   * @return	the DSRP option.
   **/
  @XmlElement(name = "Option")
  public List<Option> getOption() {
    return option;
  }
  
  /**
  * Sets the DSRP option.
  *
  * @param option the DSRP option.
  */
    public DSRPOptions option(List<Option> option) {
    this.option = option;
    return this;
  }
  
  
  /**
   * Sets the DSRP option.
   *
   * @param option the DSRP option. Adds option elements in a list. 
   *				  This is a optional method to add elements into the list. 
   */
  public DSRPOptions option(Option option) {
     this.option.add(option);
     return this;
  }
  
  
  
    
    
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public DSRPOptions extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DSRPOptions dSRPOptions = (DSRPOptions) o;
    return Objects.equals(option, dSRPOptions.option) &&
        Objects.equals(extensionPoint, dSRPOptions.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(option, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DSRPOptions {\n");
    
    sb.append("    option: ").append(toIndentedString(option)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


