package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods related to date of birth.
 **/
@Root(name = "DateOfBirth")
@XmlRootElement (name = "DateOfBirth")
public class DateOfBirth   {
  
  @SerializedName("Year")
  @Element(name = "Year")
  private Integer year = null;
  
  @SerializedName("Month")
  @Element(name = "Month")
  private Integer month = null;
  
  @SerializedName("Day")
  @Element(name = "Day")
  private Integer day = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the contact DOB Year.
   * 
   * @return	the contact DOB Year.
   **/
  @XmlElement(name = "Year")
  public Integer getYear() {
    return year;
  }
  
  /**
  * Sets the contact DOB Year.
  *
  * @param year the contact DOB Year.
  */
    public DateOfBirth year(Integer year) {
    this.year = year;
    return this;
  }
  
  
    

  
  /**
   * Gets the contact DOB Month.
   * 
   * @return	the contact DOB Month.
   **/
  @XmlElement(name = "Month")
  public Integer getMonth() {
    return month;
  }
  
  /**
  * Sets the contact DOB Month.
  *
  * @param month the contact DOB Month.
  */
    public DateOfBirth month(Integer month) {
    this.month = month;
    return this;
  }
  
  
    

  
  /**
   * Gets the contact DOB Day.
   * 
   * @return	the contact DOB Day.
   **/
  @XmlElement(name = "Day")
  public Integer getDay() {
    return day;
  }
  
  /**
  * Sets the contact DOB Day.
  *
  * @param day the contact DOB Day.
  */
    public DateOfBirth day(Integer day) {
    this.day = day;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public DateOfBirth extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DateOfBirth dateOfBirth = (DateOfBirth) o;
    return Objects.equals(year, dateOfBirth.year) &&
        Objects.equals(month, dateOfBirth.month) &&
        Objects.equals(day, dateOfBirth.day) &&
        Objects.equals(extensionPoint, dateOfBirth.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(year, month, day, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DateOfBirth {\n");
    
    sb.append("    year: ").append(toIndentedString(year)).append("\n");
    sb.append("    month: ").append(toIndentedString(month)).append("\n");
    sb.append("    day: ").append(toIndentedString(day)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


