package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * the decryption service request for android SDK.
 **/
@Root(name = "DecryptionRequest")
@XmlRootElement (name = "DecryptionRequest")
public class DecryptionRequest   {
  
  @SerializedName("Data")
  @Element(name = "Data")
  private String data = null;
  
  @SerializedName("DataEncryptionKey")
  @Element(name = "DataEncryptionKey")
  private String dataEncryptionKey = null;
  
  @SerializedName("DataEncryptionIV")
  @Element(name = "DataEncryptionIV")
  private String dataEncryptionIV = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the Data details.
   * 
   * @return	the Data details.
   **/
  @XmlElement(name = "Data")
  public String getData() {
    return data;
  }
  
  /**
  * Sets the Data details.
  *
  * @param data the Data details.
  */
    public DecryptionRequest data(String data) {
    this.data = data;
    return this;
  }
  
  
    

  
  /**
   * Gets the DataEncryptionKey details.
   * 
   * @return	the DataEncryptionKey details.
   **/
  @XmlElement(name = "DataEncryptionKey")
  public String getDataEncryptionKey() {
    return dataEncryptionKey;
  }
  
  /**
  * Sets the DataEncryptionKey details.
  *
  * @param dataEncryptionKey the DataEncryptionKey details.
  */
    public DecryptionRequest dataEncryptionKey(String dataEncryptionKey) {
    this.dataEncryptionKey = dataEncryptionKey;
    return this;
  }
  
  
    

  
  /**
   * Gets the DataEncryptionIV details.
   * 
   * @return	the DataEncryptionIV details.
   **/
  @XmlElement(name = "DataEncryptionIV")
  public String getDataEncryptionIV() {
    return dataEncryptionIV;
  }
  
  /**
  * Sets the DataEncryptionIV details.
  *
  * @param dataEncryptionIV the DataEncryptionIV details.
  */
    public DecryptionRequest dataEncryptionIV(String dataEncryptionIV) {
    this.dataEncryptionIV = dataEncryptionIV;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public DecryptionRequest extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DecryptionRequest decryptionRequest = (DecryptionRequest) o;
    return Objects.equals(data, decryptionRequest.data) &&
        Objects.equals(dataEncryptionKey, decryptionRequest.dataEncryptionKey) &&
        Objects.equals(dataEncryptionIV, decryptionRequest.dataEncryptionIV) &&
        Objects.equals(extensionPoint, decryptionRequest.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(data, dataEncryptionKey, dataEncryptionIV, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DecryptionRequest {\n");
    
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("    dataEncryptionKey: ").append(toIndentedString(dataEncryptionKey)).append("\n");
    sb.append("    dataEncryptionIV: ").append(toIndentedString(dataEncryptionIV)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


