package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * The error detail.
 **/
@Root(name = "Detail")
@XmlRootElement (name = "Detail")
public class Detail   {
  
  @SerializedName("Name")
  @Element(name = "Name")
  private String name = null;
  
  @SerializedName("Value")
  @Element(name = "Value")
  private String value = null;
  
  
  /**
   * Gets the error detail name.
   * 
   * @return	the error detail name.
   **/
  @XmlElement(name = "Name")
  public String getName() {
    return name;
  }
  
  /**
  * Sets the error detail name.
  *
  * @param name the error detail name.
  */
    public Detail name(String name) {
    this.name = name;
    return this;
  }
  
  
    

  
  /**
   * Gets the error detail name.
   * 
   * @return	the error detail name.
   **/
  @XmlElement(name = "Value")
  public String getValue() {
    return value;
  }
  
  /**
  * Sets the error detail name.
  *
  * @param value the error detail name.
  */
    public Detail value(String value) {
    this.value = value;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Detail detail = (Detail) o;
    return Objects.equals(name, detail.name) &&
        Objects.equals(value, detail.value);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(name, value);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Detail {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


