package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.Detail;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.*;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * The error details.
 **/
@Root(name = "Details")
@XmlRootElement (name = "Details")
public class Details   {
  
  @SerializedName("Detail")
  @ElementList(name = "Detail" , inline = true, entry = "Detail", required = false)
  private List<Detail> detail = new ArrayList<Detail>();
  
  
  /**
   * Gets the error detail.
   * 
   * @return	the error detail.
   **/
  @XmlElement(name = "Detail")
  public List<Detail> getDetail() {
    return detail;
  }
  
  /**
  * Sets the error detail.
  *
  * @param detail the error detail.
  */
    public Details detail(List<Detail> detail) {
    this.detail = detail;
    return this;
  }
  
  
  /**
   * Sets the error detail.
   *
   * @param detail the error detail. Adds detail elements in a list. 
   *				  This is a optional method to add elements into the list. 
   */
  public Details detail(Detail detail) {
     this.detail.add(detail);
     return this;
  }
  
  
  
    
    
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Details details = (Details) o;
    return Objects.equals(detail, details.detail);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(detail);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Details {\n");
    
    sb.append("    detail: ").append(toIndentedString(detail)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


