package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.Details;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods require for error handling.
 **/
@Root(name = "Error")
@XmlRootElement (name = "Error")
public class Error   {
  
  @SerializedName("Description")
  @Element(name = "Description", required = false)
  private String description = null;
  
  @SerializedName("ReasonCode")
  @Element(name = "ReasonCode")
  private String reasonCode = null;
  
  @SerializedName("Recoverable")
  @Element(name = "Recoverable")
  private Boolean recoverable = null;
  
  @SerializedName("Source")
  @Element(name = "Source")
  private String source = null;
  
  @SerializedName("Details")
  @Element(name = "Details", required = false)
  private Details details = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the error description.
   * 
   * @return	the error description.
   **/
  @XmlElement(name = "Description")
  public String getDescription() {
    return description;
  }
  
  /**
  * Sets the error description.
  *
  * @param description the error description.
  */
    public Error description(String description) {
    this.description = description;
    return this;
  }
  
  
    

  
  /**
   * Gets the error reason code.
   * 
   * @return	the error reason code.
   **/
  @XmlElement(name = "ReasonCode")
  public String getReasonCode() {
    return reasonCode;
  }
  
  /**
  * Sets the error reason code.
  *
  * @param reasonCode the error reason code.
  */
    public Error reasonCode(String reasonCode) {
    this.reasonCode = reasonCode;
    return this;
  }
  
  
    

  
  /**
   * Gets the error recoverable info.
   * 
   * @return	the error recoverable info.
   **/
  @XmlElement(name = "Recoverable")
  public Boolean getRecoverable() {
    return recoverable;
  }
  
  /**
  * Sets the error recoverable info.
  *
  * @param recoverable the error recoverable info.
  */
    public Error recoverable(Boolean recoverable) {
    this.recoverable = recoverable;
    return this;
  }
  
  
    

  
  /**
   * Gets the source of error.
   * 
   * @return	the source of error.
   **/
  @XmlElement(name = "Source")
  public String getSource() {
    return source;
  }
  
  /**
  * Sets the source of error.
  *
  * @param source the source of error.
  */
    public Error source(String source) {
    this.source = source;
    return this;
  }
  
  
    

  
  /**
   * Gets the error details.
   * 
   * @return	the error details.
   **/
  @XmlElement(name = "Details")
  public Details getDetails() {
    return details;
  }
  
  /**
  * Sets the error details.
  *
  * @param details the error details.
  */
    public Error details(Details details) {
    this.details = details;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public Error extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Error error = (Error) o;
    return Objects.equals(description, error.description) &&
        Objects.equals(reasonCode, error.reasonCode) &&
        Objects.equals(recoverable, error.recoverable) &&
        Objects.equals(source, error.source) &&
        Objects.equals(details, error.details) &&
        Objects.equals(extensionPoint, error.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(description, reasonCode, recoverable, source, details, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Error {\n");
    
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    reasonCode: ").append(toIndentedString(reasonCode)).append("\n");
    sb.append("    recoverable: ").append(toIndentedString(recoverable)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    details: ").append(toIndentedString(details)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


