package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods require for express checkout request.
 **/
@Root(name = "ExpressCheckoutRequest")
@XmlRootElement (name = "ExpressCheckoutRequest")
public class ExpressCheckoutRequest   {
  
  @SerializedName("MerchantCheckoutId")
  @Element(name = "MerchantCheckoutId")
  private String merchantCheckoutId = null;
  
  @SerializedName("PrecheckoutTransactionId")
  @Element(name = "PrecheckoutTransactionId")
  private String precheckoutTransactionId = null;
  
  @SerializedName("CurrencyCode")
  @Element(name = "CurrencyCode")
  private String currencyCode = null;
  
  @SerializedName("OrderAmount")
  @Element(name = "OrderAmount")
  private Long orderAmount = null;
  
  @SerializedName("CardId")
  @Element(name = "CardId")
  private String cardId = null;
  
  @SerializedName("DigitalGoods")
  @Element(name = "DigitalGoods", required = false)
  private Boolean digitalGoods = null;
  
  @SerializedName("ShippingAddressId")
  @Element(name = "ShippingAddressId", required = false)
  private String shippingAddressId = null;
  
  @SerializedName("RewardProgramId")
  @Element(name = "RewardProgramId", required = false)
  private String rewardProgramId = null;
  
  @SerializedName("AdvancedCheckoutOverride")
  @Element(name = "AdvancedCheckoutOverride")
  private Boolean advancedCheckoutOverride = null;
  
  @SerializedName("OriginUrl")
  @Element(name = "OriginUrl", required = false)
  private String originUrl = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the merchant checkout id.
   * 
   * @return	the merchant checkout id.
   **/
  @XmlElement(name = "MerchantCheckoutId")
  public String getMerchantCheckoutId() {
    return merchantCheckoutId;
  }
  
  /**
  * Sets the merchant checkout id.
  *
  * @param merchantCheckoutId the merchant checkout id.
  */
    public ExpressCheckoutRequest merchantCheckoutId(String merchantCheckoutId) {
    this.merchantCheckoutId = merchantCheckoutId;
    return this;
  }
  
  
    

  
  /**
   * Gets the unique id of the transaction.
   * 
   * @return	the unique id of the transaction.
   **/
  @XmlElement(name = "PrecheckoutTransactionId")
  public String getPrecheckoutTransactionId() {
    return precheckoutTransactionId;
  }
  
  /**
  * Sets the unique id of the transaction.
  *
  * @param precheckoutTransactionId the unique id of the transaction.
  */
    public ExpressCheckoutRequest precheckoutTransactionId(String precheckoutTransactionId) {
    this.precheckoutTransactionId = precheckoutTransactionId;
    return this;
  }
  
  
    

  
  /**
   * Gets the currency code as ISO 4217 standard (for example, USD).
   * 
   * @return	the currency code as ISO 4217 standard (for example, USD).
   **/
  @XmlElement(name = "CurrencyCode")
  public String getCurrencyCode() {
    return currencyCode;
  }
  
  /**
  * Sets the currency code as ISO 4217 standard (for example, USD).
  *
  * @param currencyCode the currency code as ISO 4217 standard (for example, USD).
  */
    public ExpressCheckoutRequest currencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }
  
  
    

  
  /**
   * Gets the order amount of the transaction.
   * 
   * @return	the order amount of the transaction.
   **/
  @XmlElement(name = "OrderAmount")
  public Long getOrderAmount() {
    return orderAmount;
  }
  
  /**
  * Sets the order amount of the transaction.
  *
  * @param orderAmount the order amount of the transaction.
  */
    public ExpressCheckoutRequest orderAmount(Long orderAmount) {
    this.orderAmount = orderAmount;
    return this;
  }
  
  
    

  
  /**
   * Gets the id assigned to the card.
   * 
   * @return	the id assigned to the card.
   **/
  @XmlElement(name = "CardId")
  public String getCardId() {
    return cardId;
  }
  
  /**
  * Sets the id assigned to the card.
  *
  * @param cardId the id assigned to the card.
  */
    public ExpressCheckoutRequest cardId(String cardId) {
    this.cardId = cardId;
    return this;
  }
  
  
    

  
  /**
   * Gets the digital goods flag. Set to true if it's a digital good and no shipping is required (for example, digital music, online games, and so on); optional.
   * 
   * @return	the digital goods flag. Set to true if it's a digital good and no shipping is required (for example, digital music, online games, and so on); optional.
   **/
  @XmlElement(name = "DigitalGoods")
  public Boolean getDigitalGoods() {
    return digitalGoods;
  }
  
  /**
  * Sets the digital goods flag. Set to true if it's a digital good and no shipping is required (for example, digital music, online games, and so on); optional.
  *
  * @param digitalGoods the digital goods flag. Set to true if it's a digital good and no shipping is required (for example, digital music, online games, and so on); optional.
  */
    public ExpressCheckoutRequest digitalGoods(Boolean digitalGoods) {
    this.digitalGoods = digitalGoods;
    return this;
  }
  
  
    

  
  /**
   * Gets the id assigned to the shipping address.
   * 
   * @return	the id assigned to the shipping address.
   **/
  @XmlElement(name = "ShippingAddressId")
  public String getShippingAddressId() {
    return shippingAddressId;
  }
  
  /**
  * Sets the id assigned to the shipping address.
  *
  * @param shippingAddressId the id assigned to the shipping address.
  */
    public ExpressCheckoutRequest shippingAddressId(String shippingAddressId) {
    this.shippingAddressId = shippingAddressId;
    return this;
  }
  
  
    

  
  /**
   * Gets the id assigned to the reward program.
   * 
   * @return	the id assigned to the reward program.
   **/
  @XmlElement(name = "RewardProgramId")
  public String getRewardProgramId() {
    return rewardProgramId;
  }
  
  /**
  * Sets the id assigned to the reward program.
  *
  * @param rewardProgramId the id assigned to the reward program.
  */
    public ExpressCheckoutRequest rewardProgramId(String rewardProgramId) {
    this.rewardProgramId = rewardProgramId;
    return this;
  }
  
  
    

  
  /**
   * Gets the advanced checkout override flag. Set to true to override and disable 3-D Secure for current transaction.
   * 
   * @return	the advanced checkout override flag. Set to true to override and disable 3-D Secure for current transaction.
   **/
  @XmlElement(name = "AdvancedCheckoutOverride")
  public Boolean getAdvancedCheckoutOverride() {
    return advancedCheckoutOverride;
  }
  
  /**
  * Sets the advanced checkout override flag. Set to true to override and disable 3-D Secure for current transaction.
  *
  * @param advancedCheckoutOverride the advanced checkout override flag. Set to true to override and disable 3-D Secure for current transaction.
  */
    public ExpressCheckoutRequest advancedCheckoutOverride(Boolean advancedCheckoutOverride) {
    this.advancedCheckoutOverride = advancedCheckoutOverride;
    return this;
  }
  
  
    

  
  /**
   * Gets the URL that the merchant is using to initialize the Lightbox.
   * 
   * @return	the URL that the merchant is using to initialize the Lightbox.
   **/
  @XmlElement(name = "OriginUrl")
  public String getOriginUrl() {
    return originUrl;
  }
  
  /**
  * Sets the URL that the merchant is using to initialize the Lightbox.
  *
  * @param originUrl the URL that the merchant is using to initialize the Lightbox.
  */
    public ExpressCheckoutRequest originUrl(String originUrl) {
    this.originUrl = originUrl;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public ExpressCheckoutRequest extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExpressCheckoutRequest expressCheckoutRequest = (ExpressCheckoutRequest) o;
    return Objects.equals(merchantCheckoutId, expressCheckoutRequest.merchantCheckoutId) &&
        Objects.equals(precheckoutTransactionId, expressCheckoutRequest.precheckoutTransactionId) &&
        Objects.equals(currencyCode, expressCheckoutRequest.currencyCode) &&
        Objects.equals(orderAmount, expressCheckoutRequest.orderAmount) &&
        Objects.equals(cardId, expressCheckoutRequest.cardId) &&
        Objects.equals(digitalGoods, expressCheckoutRequest.digitalGoods) &&
        Objects.equals(shippingAddressId, expressCheckoutRequest.shippingAddressId) &&
        Objects.equals(rewardProgramId, expressCheckoutRequest.rewardProgramId) &&
        Objects.equals(advancedCheckoutOverride, expressCheckoutRequest.advancedCheckoutOverride) &&
        Objects.equals(originUrl, expressCheckoutRequest.originUrl) &&
        Objects.equals(extensionPoint, expressCheckoutRequest.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(merchantCheckoutId, precheckoutTransactionId, currencyCode, orderAmount, cardId, digitalGoods, shippingAddressId, rewardProgramId, advancedCheckoutOverride, originUrl, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExpressCheckoutRequest {\n");
    
    sb.append("    merchantCheckoutId: ").append(toIndentedString(merchantCheckoutId)).append("\n");
    sb.append("    precheckoutTransactionId: ").append(toIndentedString(precheckoutTransactionId)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    orderAmount: ").append(toIndentedString(orderAmount)).append("\n");
    sb.append("    cardId: ").append(toIndentedString(cardId)).append("\n");
    sb.append("    digitalGoods: ").append(toIndentedString(digitalGoods)).append("\n");
    sb.append("    shippingAddressId: ").append(toIndentedString(shippingAddressId)).append("\n");
    sb.append("    rewardProgramId: ").append(toIndentedString(rewardProgramId)).append("\n");
    sb.append("    advancedCheckoutOverride: ").append(toIndentedString(advancedCheckoutOverride)).append("\n");
    sb.append("    originUrl: ").append(toIndentedString(originUrl)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


