package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.Checkout;
import com.mastercard.masterpass.merchant.model.Errors;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods require for express checkout response.
 **/
@Root(name = "ExpressCheckoutResponse")
@XmlRootElement (name = "ExpressCheckoutResponse")
public class ExpressCheckoutResponse   {
  
  @SerializedName("Checkout")
  @Element(name = "Checkout", required = false)
  private Checkout checkout = null;
  
  @SerializedName("LongAccessToken")
  @Element(name = "LongAccessToken", required = false)
  private String longAccessToken = null;
  
  @SerializedName("Errors")
  @Element(name = "Errors", required = false)
  private Errors errors = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the checkout details.
   * 
   * @return	the checkout details.
   **/
  @XmlElement(name = "Checkout")
  public Checkout getCheckout() {
    return checkout;
  }
  
  /**
  * Sets the checkout details.
  *
  * @param checkout the checkout details.
  */
    public ExpressCheckoutResponse checkout(Checkout checkout) {
    this.checkout = checkout;
    return this;
  }
  
  
    

  
  /**
   * Gets the long access token.
   * 
   * @return	the long access token.
   **/
  @XmlElement(name = "LongAccessToken")
  public String getLongAccessToken() {
    return longAccessToken;
  }
  
  /**
  * Sets the long access token.
  *
  * @param longAccessToken the long access token.
  */
    public ExpressCheckoutResponse longAccessToken(String longAccessToken) {
    this.longAccessToken = longAccessToken;
    return this;
  }
  
  
    

  
  /**
   * Gets the errors information.
   * 
   * @return	the errors information.
   **/
  @XmlElement(name = "Errors")
  public Errors getErrors() {
    return errors;
  }
  
  /**
  * Sets the errors information.
  *
  * @param errors the errors information.
  */
    public ExpressCheckoutResponse errors(Errors errors) {
    this.errors = errors;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public ExpressCheckoutResponse extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExpressCheckoutResponse expressCheckoutResponse = (ExpressCheckoutResponse) o;
    return Objects.equals(checkout, expressCheckoutResponse.checkout) &&
        Objects.equals(longAccessToken, expressCheckoutResponse.longAccessToken) &&
        Objects.equals(errors, expressCheckoutResponse.errors) &&
        Objects.equals(extensionPoint, expressCheckoutResponse.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(checkout, longAccessToken, errors, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExpressCheckoutResponse {\n");
    
    sb.append("    checkout: ").append(toIndentedString(checkout)).append("\n");
    sb.append("    longAccessToken: ").append(toIndentedString(longAccessToken)).append("\n");
    sb.append("    errors: ").append(toIndentedString(errors)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


