package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.Brands;
import com.mastercard.masterpass.merchant.model.InstallmentOptions;
import com.mastercard.masterpass.merchant.model.Issuers;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods regarding installment.
 **/
@Root(name = "Installment")
@XmlRootElement (name = "Installment")
public class Installment   {
  
  @SerializedName("Brands")
  @Element(name = "Brands", required = false)
  private Brands brands = null;
  
  @SerializedName("Issuers")
  @Element(name = "Issuers", required = false)
  private Issuers issuers = null;
  
  @SerializedName("CurrencyCode")
  @Element(name = "CurrencyCode", required = false)
  private String currencyCode = null;
  

public enum ShippingCalculationEnum {
  @SerializedName("FREE_SHIPPING")
  FREE_SHIPPING("FREE_SHIPPING"),

  @SerializedName("SHIPPING_INCLUDED")
  SHIPPING_INCLUDED("SHIPPING_INCLUDED"),

  @SerializedName("SHIPPING_NOT_INCLUDED")
  SHIPPING_NOT_INCLUDED("SHIPPING_NOT_INCLUDED");

  private String value;

  ShippingCalculationEnum(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return value;
  }
}

  @SerializedName("ShippingCalculation")
  @Element(name = "ShippingCalculation", required = false)
  private ShippingCalculationEnum shippingCalculation = null;
  
  @SerializedName("InstallmentOptions")
  @Element(name = "InstallmentOptions", required = false)
  private InstallmentOptions installmentOptions = null;
  
  
  /**
   * Gets the brand details.
   * 
   * @return	the brand details.
   **/
  @XmlElement(name = "Brands")
  public Brands getBrands() {
    return brands;
  }
  
  /**
  * Sets the brand details.
  *
  * @param brands the brand details.
  */
    public Installment brands(Brands brands) {
    this.brands = brands;
    return this;
  }
  
  
    

  
  /**
   * Gets the issuers details.
   * 
   * @return	the issuers details.
   **/
  @XmlElement(name = "Issuers")
  public Issuers getIssuers() {
    return issuers;
  }
  
  /**
  * Sets the issuers details.
  *
  * @param issuers the issuers details.
  */
    public Installment issuers(Issuers issuers) {
    this.issuers = issuers;
    return this;
  }
  
  
    

  
  /**
   * Gets the currency code.
   * 
   * @return	the currency code.
   **/
  @XmlElement(name = "CurrencyCode")
  public String getCurrencyCode() {
    return currencyCode;
  }
  
  /**
  * Sets the currency code.
  *
  * @param currencyCode the currency code.
  */
    public Installment currencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }
  
  
    

  
  /**
   * Gets the shipping calculation types.
   * 
   * @return	the shipping calculation types.
   **/
  @XmlElement(name = "ShippingCalculation")
  public ShippingCalculationEnum getShippingCalculation() {
    return shippingCalculation;
  }
  
  /**
  * Sets the shipping calculation types.
  *
  * @param shippingCalculation the shipping calculation types.
  */
    public Installment shippingCalculation(ShippingCalculationEnum shippingCalculation) {
    this.shippingCalculation = shippingCalculation;
    return this;
  }
  
  
    

  
  /**
   * Gets the installment options.
   * 
   * @return	the installment options.
   **/
  @XmlElement(name = "InstallmentOptions")
  public InstallmentOptions getInstallmentOptions() {
    return installmentOptions;
  }
  
  /**
  * Sets the installment options.
  *
  * @param installmentOptions the installment options.
  */
    public Installment installmentOptions(InstallmentOptions installmentOptions) {
    this.installmentOptions = installmentOptions;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Installment installment = (Installment) o;
    return Objects.equals(brands, installment.brands) &&
        Objects.equals(issuers, installment.issuers) &&
        Objects.equals(currencyCode, installment.currencyCode) &&
        Objects.equals(shippingCalculation, installment.shippingCalculation) &&
        Objects.equals(installmentOptions, installment.installmentOptions);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(brands, issuers, currencyCode, shippingCalculation, installmentOptions);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Installment {\n");
    
    sb.append("    brands: ").append(toIndentedString(brands)).append("\n");
    sb.append("    issuers: ").append(toIndentedString(issuers)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    shippingCalculation: ").append(toIndentedString(shippingCalculation)).append("\n");
    sb.append("    installmentOptions: ").append(toIndentedString(installmentOptions)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


