package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods require to set installment details.
 **/
@Root(name = "InstallmentOption")
@XmlRootElement (name = "InstallmentOption")
public class InstallmentOption   {
  
  @SerializedName("NumberOfInstallments")
  @Element(name = "NumberOfInstallments")
  private Integer numberOfInstallments = null;
  
  @SerializedName("PricePerInstallment")
  @Element(name = "PricePerInstallment")
  private Long pricePerInstallment = null;
  
  @SerializedName("InterestRate")
  @Element(name = "InterestRate")
  private String interestRate = null;
  
  @SerializedName("CurrencyCode")
  @Element(name = "CurrencyCode")
  private String currencyCode = null;
  
  
  /**
   * Gets the number of installments.
   * 
   * @return	the number of installments.
   **/
  @XmlElement(name = "NumberOfInstallments")
  public Integer getNumberOfInstallments() {
    return numberOfInstallments;
  }
  
  /**
  * Sets the number of installments.
  *
  * @param numberOfInstallments the number of installments.
  */
    public InstallmentOption numberOfInstallments(Integer numberOfInstallments) {
    this.numberOfInstallments = numberOfInstallments;
    return this;
  }
  
  
    

  
  /**
   * Gets the price per installment.
   * 
   * @return	the price per installment.
   **/
  @XmlElement(name = "PricePerInstallment")
  public Long getPricePerInstallment() {
    return pricePerInstallment;
  }
  
  /**
  * Sets the price per installment.
  *
  * @param pricePerInstallment the price per installment.
  */
    public InstallmentOption pricePerInstallment(Long pricePerInstallment) {
    this.pricePerInstallment = pricePerInstallment;
    return this;
  }
  
  
    

  
  /**
   * Gets the interest rate.
   * 
   * @return	the interest rate.
   **/
  @XmlElement(name = "InterestRate")
  public String getInterestRate() {
    return interestRate;
  }
  
  /**
  * Sets the interest rate.
  *
  * @param interestRate the interest rate.
  */
    public InstallmentOption interestRate(String interestRate) {
    this.interestRate = interestRate;
    return this;
  }
  
  
    

  
  /**
   * Gets the currency code.
   * 
   * @return	the currency code.
   **/
  @XmlElement(name = "CurrencyCode")
  public String getCurrencyCode() {
    return currencyCode;
  }
  
  /**
  * Sets the currency code.
  *
  * @param currencyCode the currency code.
  */
    public InstallmentOption currencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InstallmentOption installmentOption = (InstallmentOption) o;
    return Objects.equals(numberOfInstallments, installmentOption.numberOfInstallments) &&
        Objects.equals(pricePerInstallment, installmentOption.pricePerInstallment) &&
        Objects.equals(interestRate, installmentOption.interestRate) &&
        Objects.equals(currencyCode, installmentOption.currencyCode);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(numberOfInstallments, pricePerInstallment, interestRate, currencyCode);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InstallmentOption {\n");
    
    sb.append("    numberOfInstallments: ").append(toIndentedString(numberOfInstallments)).append("\n");
    sb.append("    pricePerInstallment: ").append(toIndentedString(pricePerInstallment)).append("\n");
    sb.append("    interestRate: ").append(toIndentedString(interestRate)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


