package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.Installment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.*;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods for payment installment options.
 **/
@Root(name = "Installments")
@XmlRootElement (name = "Installments")
public class Installments   {
  
  @SerializedName("Installment")
  @ElementList(name = "Installment" , inline = true, entry = "Installment")
  private List<Installment> installment = new ArrayList<Installment>();
  
  
  /**
   * Gets the acceptance options.
   * 
   * @return	the acceptance options.
   **/
  @XmlElement(name = "Installment")
  public List<Installment> getInstallment() {
    return installment;
  }
  
  /**
  * Sets the acceptance options.
  *
  * @param installment the acceptance options.
  */
    public Installments installment(List<Installment> installment) {
    this.installment = installment;
    return this;
  }
  
  
  /**
   * Sets the acceptance options.
   *
   * @param installment the acceptance options. Adds installment elements in a list. 
   *				  This is a optional method to add elements into the list. 
   */
  public Installments installment(Installment installment) {
     this.installment.add(installment);
     return this;
  }
  
  
  
    
    
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Installments installments = (Installments) o;
    return Objects.equals(installment, installments.installment);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(installment);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Installments {\n");
    
    sb.append("    installment: ").append(toIndentedString(installment)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


