package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.DSRPExtension;
import com.mastercard.masterpass.merchant.model.PaymentOptionsExtensions;
import com.mastercard.masterpass.merchant.model.PrivateDatas;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods require to set DSRP details for merchant initialization request during DSRP.
 **/
@Root(name = "MerchantInitializationExtension")
@XmlRootElement (name = "MerchantInitializationExtension")
public class MerchantInitializationExtension   {
  
  @SerializedName("DSRP")
  @Element(name = "DSRP")
  private DSRPExtension DSRP = null;
  
  @SerializedName("SecondaryOriginUrl")
  @Element(name = "SecondaryOriginUrl", required = false)
  private String secondaryOriginUrl = null;
  
  @SerializedName("PaymentOptions")
  @Element(name = "PaymentOptions", required = false)
  private PaymentOptionsExtensions paymentOptions = null;
  
  @SerializedName("PrivateDatas")
  @Element(name = "PrivateDatas", required = false)
  private PrivateDatas privateDatas = null;
  
  
  /**
   * Gets the DSRP for merchant initialization request.
   * 
   * @return	the DSRP for merchant initialization request.
   **/
  @XmlElement(name = "DSRP")
  public DSRPExtension getDSRP() {
    return DSRP;
  }
  
  /**
  * Sets the DSRP for merchant initialization request.
  *
  * @param DSRP the DSRP for merchant initialization request.
  */
    public MerchantInitializationExtension DSRP(DSRPExtension DSRP) {
    this.DSRP = DSRP;
    return this;
  }
  
  
    

  
  /**
   * Gets the secondary origin url.
   * 
   * @return	the secondary origin url.
   **/
  @XmlElement(name = "SecondaryOriginUrl")
  public String getSecondaryOriginUrl() {
    return secondaryOriginUrl;
  }
  
  /**
  * Sets the secondary origin url.
  *
  * @param secondaryOriginUrl the secondary origin url.
  */
    public MerchantInitializationExtension secondaryOriginUrl(String secondaryOriginUrl) {
    this.secondaryOriginUrl = secondaryOriginUrl;
    return this;
  }
  
  
    

  
  /**
   * Gets the payment options.
   * 
   * @return	the payment options.
   **/
  @XmlElement(name = "PaymentOptions")
  public PaymentOptionsExtensions getPaymentOptions() {
    return paymentOptions;
  }
  
  /**
  * Sets the payment options.
  *
  * @param paymentOptions the payment options.
  */
    public MerchantInitializationExtension paymentOptions(PaymentOptionsExtensions paymentOptions) {
    this.paymentOptions = paymentOptions;
    return this;
  }
  
  
    

  
  /**
   * Gets the private data.
   * 
   * @return	the private data.
   **/
  @XmlElement(name = "PrivateDatas")
  public PrivateDatas getPrivateDatas() {
    return privateDatas;
  }
  
  /**
  * Sets the private data.
  *
  * @param privateDatas the private data.
  */
    public MerchantInitializationExtension privateDatas(PrivateDatas privateDatas) {
    this.privateDatas = privateDatas;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MerchantInitializationExtension merchantInitializationExtension = (MerchantInitializationExtension) o;
    return Objects.equals(DSRP, merchantInitializationExtension.DSRP) &&
        Objects.equals(secondaryOriginUrl, merchantInitializationExtension.secondaryOriginUrl) &&
        Objects.equals(paymentOptions, merchantInitializationExtension.paymentOptions) &&
        Objects.equals(privateDatas, merchantInitializationExtension.privateDatas);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(DSRP, secondaryOriginUrl, paymentOptions, privateDatas);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MerchantInitializationExtension {\n");
    
    sb.append("    DSRP: ").append(toIndentedString(DSRP)).append("\n");
    sb.append("    secondaryOriginUrl: ").append(toIndentedString(secondaryOriginUrl)).append("\n");
    sb.append("    paymentOptions: ").append(toIndentedString(paymentOptions)).append("\n");
    sb.append("    privateDatas: ").append(toIndentedString(privateDatas)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


