package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.MerchantInitializationExtension;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains various methods for to set different merchant initialization request parameters required for Merchant Initialization Service.
 **/
@Root(name = "MerchantInitializationRequest")
@XmlRootElement (name = "MerchantInitializationRequest")
public class MerchantInitializationRequest   {
  
  @SerializedName("OAuthToken")
  @Element(name = "OAuthToken")
  private String oAuthToken = null;
  
  @SerializedName("PreCheckoutTransactionId")
  @Element(name = "PreCheckoutTransactionId", required = false)
  private String preCheckoutTransactionId = null;
  
  @SerializedName("OriginUrl")
  @Element(name = "OriginUrl")
  private String originUrl = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private MerchantInitializationExtension extensionPoint = null;
  
  
  /**
   * Gets the Request Token (oauth_token) returned by call to the request_token API.
   * 
   * @return	the Request Token (oauth_token) returned by call to the request_token API.
   **/
  @XmlElement(name = "OAuthToken")
  public String getOAuthToken() {
    return oAuthToken;
  }
  
  /**
  * Sets the Request Token (oauth_token) returned by call to the request_token API.
  *
  * @param oAuthToken the Request Token (oauth_token) returned by call to the request_token API.
  */
    public MerchantInitializationRequest oAuthToken(String oAuthToken) {
    this.oAuthToken = oAuthToken;
    return this;
  }
  
  
    

  
  /**
   * Gets the precheckout transaction identifier. Returned from get precheckout data call.
   * 
   * @return	the precheckout transaction identifier. Returned from get precheckout data call.
   **/
  @XmlElement(name = "PreCheckoutTransactionId")
  public String getPreCheckoutTransactionId() {
    return preCheckoutTransactionId;
  }
  
  /**
  * Sets the precheckout transaction identifier. Returned from get precheckout data call.
  *
  * @param preCheckoutTransactionId the precheckout transaction identifier. Returned from get precheckout data call.
  */
    public MerchantInitializationRequest preCheckoutTransactionId(String preCheckoutTransactionId) {
    this.preCheckoutTransactionId = preCheckoutTransactionId;
    return this;
  }
  
  
    

  
  /**
   * Gets the URL of the page that will initialize the Lightbox.
   * 
   * @return	the URL of the page that will initialize the Lightbox.
   **/
  @XmlElement(name = "OriginUrl")
  public String getOriginUrl() {
    return originUrl;
  }
  
  /**
  * Sets the URL of the page that will initialize the Lightbox.
  *
  * @param originUrl the URL of the page that will initialize the Lightbox.
  */
    public MerchantInitializationRequest originUrl(String originUrl) {
    this.originUrl = originUrl;
    return this;
  }
  
  
    

  
  /**
   * Gets the MerchantInitializationExtension for DSRP/future enhancement.
   * 
   * @return	the MerchantInitializationExtension for DSRP/future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public MerchantInitializationExtension getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the MerchantInitializationExtension for DSRP/future enhancement.
  *
  * @param extensionPoint the MerchantInitializationExtension for DSRP/future enhancement.
  */
    public MerchantInitializationRequest extensionPoint(MerchantInitializationExtension extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MerchantInitializationRequest merchantInitializationRequest = (MerchantInitializationRequest) o;
    return Objects.equals(oAuthToken, merchantInitializationRequest.oAuthToken) &&
        Objects.equals(preCheckoutTransactionId, merchantInitializationRequest.preCheckoutTransactionId) &&
        Objects.equals(originUrl, merchantInitializationRequest.originUrl) &&
        Objects.equals(extensionPoint, merchantInitializationRequest.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(oAuthToken, preCheckoutTransactionId, originUrl, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MerchantInitializationRequest {\n");
    
    sb.append("    oAuthToken: ").append(toIndentedString(oAuthToken)).append("\n");
    sb.append("    preCheckoutTransactionId: ").append(toIndentedString(preCheckoutTransactionId)).append("\n");
    sb.append("    originUrl: ").append(toIndentedString(originUrl)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


