package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.MerchantInitializationResponseExtension;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains various methods for to get the different values returned by Merchant Initialization Service.
 **/
@Root(name = "MerchantInitializationResponse")
@XmlRootElement (name = "MerchantInitializationResponse")
public class MerchantInitializationResponse   {
  
  @SerializedName("OAuthToken")
  @Element(name = "OAuthToken")
  private String oAuthToken = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private MerchantInitializationResponseExtension extensionPoint = null;
  
  
  /**
   * Gets the Request Token (oauth_token) returned by call to the request_token API.
   * 
   * @return	the Request Token (oauth_token) returned by call to the request_token API.
   **/
  @XmlElement(name = "OAuthToken")
  public String getOAuthToken() {
    return oAuthToken;
  }
  
  /**
  * Sets the Request Token (oauth_token) returned by call to the request_token API.
  *
  * @param oAuthToken the Request Token (oauth_token) returned by call to the request_token API.
  */
    public MerchantInitializationResponse oAuthToken(String oAuthToken) {
    this.oAuthToken = oAuthToken;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for DSRP/future enhancement.
   * 
   * @return	the ExtensionPoint for DSRP/future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public MerchantInitializationResponseExtension getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for DSRP/future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for DSRP/future enhancement.
  */
    public MerchantInitializationResponse extensionPoint(MerchantInitializationResponseExtension extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MerchantInitializationResponse merchantInitializationResponse = (MerchantInitializationResponse) o;
    return Objects.equals(oAuthToken, merchantInitializationResponse.oAuthToken) &&
        Objects.equals(extensionPoint, merchantInitializationResponse.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(oAuthToken, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MerchantInitializationResponse {\n");
    
    sb.append("    oAuthToken: ").append(toIndentedString(oAuthToken)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


