package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class return the response for DSRP during merchant initialization service.
 **/
@Root(name = "MerchantInitializationResponseExtension")
@XmlRootElement (name = "MerchantInitializationResponseExtension")
public class MerchantInitializationResponseExtension   {
  
  @SerializedName("UnpredictableNumber")
  @Element(name = "UnpredictableNumber", required = false)
  private String unpredictableNumber = null;
  
  
  /**
   * Gets the unpredictable number.
   * 
   * @return	the unpredictable number.
   **/
  @XmlElement(name = "UnpredictableNumber")
  public String getUnpredictableNumber() {
    return unpredictableNumber;
  }
  
  /**
  * Sets the unpredictable number.
  *
  * @param unpredictableNumber the unpredictable number.
  */
    public MerchantInitializationResponseExtension unpredictableNumber(String unpredictableNumber) {
    this.unpredictableNumber = unpredictableNumber;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MerchantInitializationResponseExtension merchantInitializationResponseExtension = (MerchantInitializationResponseExtension) o;
    return Objects.equals(unpredictableNumber, merchantInitializationResponseExtension.unpredictableNumber);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(unpredictableNumber);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MerchantInitializationResponseExtension {\n");
    
    sb.append("    unpredictableNumber: ").append(toIndentedString(unpredictableNumber)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


