package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.MerchantTransaction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.*;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods to post the result of success and fail transactions. This contains information require for a service call from the merchant to MasterPass.
 **/
@Root(name = "MerchantTransactions")
@XmlRootElement (name = "MerchantTransactions")
public class MerchantTransactions   {
  
  @SerializedName("MerchantTransactions")
  @ElementList(name = "MerchantTransactions" , inline = true, entry = "MerchantTransactions", required = false)
  private List<MerchantTransaction> merchantTransactions = new ArrayList<MerchantTransaction>();
  
  
  /**
   * Gets the merchant transaction details.
   * 
   * @return	the merchant transaction details.
   **/
  @XmlElement(name = "MerchantTransactions")
  public List<MerchantTransaction> getMerchantTransactions() {
    return merchantTransactions;
  }
  
  /**
  * Sets the merchant transaction details.
  *
  * @param merchantTransactions the merchant transaction details.
  */
    public MerchantTransactions merchantTransactions(List<MerchantTransaction> merchantTransactions) {
    this.merchantTransactions = merchantTransactions;
    return this;
  }
  
  
  /**
   * Sets the merchant transaction details.
   *
   * @param merchantTransactions the merchant transaction details. Adds merchantTransactions elements in a list. 
   *				  This is a optional method to add elements into the list. 
   */
  public MerchantTransactions merchantTransactions(MerchantTransaction merchantTransactions) {
     this.merchantTransactions.add(merchantTransactions);
     return this;
  }
  
  
  
    
    
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MerchantTransactions merchantTransactions = (MerchantTransactions) o;
    return Objects.equals(merchantTransactions, merchantTransactions.merchantTransactions);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(merchantTransactions);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MerchantTransactions {\n");
    
    sb.append("    merchantTransactions: ").append(toIndentedString(merchantTransactions)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


