package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods require to set option details for merchant initialization request during DSRP.
 **/
@Root(name = "Option")
@XmlRootElement (name = "Option")
public class Option   {
  
  @SerializedName("BrandId")
  @Element(name = "BrandId")
  private String brandId = null;
  

public enum AcceptanceTypeEnum {
  @SerializedName("NONE")
  NONE("NONE"),

  @SerializedName("ICC")
  ICC("ICC"),

  @SerializedName("UCAF")
  UCAF("UCAF");

  private String value;

  AcceptanceTypeEnum(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return value;
  }
}

  @SerializedName("AcceptanceType")
  @Element(name = "AcceptanceType")
  private AcceptanceTypeEnum acceptanceType = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the brand id required for DSRP transactions. Identifies the card brands for which DSRP is desired. Currently, the only valid card ID is: master
   * 
   * @return	the brand id required for DSRP transactions. Identifies the card brands for which DSRP is desired. Currently, the only valid card ID is: master
   **/
  @XmlElement(name = "BrandId")
  public String getBrandId() {
    return brandId;
  }
  
  /**
  * Sets the brand id required for DSRP transactions. Identifies the card brands for which DSRP is desired. Currently, the only valid card ID is: master
  *
  * @param brandId the brand id required for DSRP transactions. Identifies the card brands for which DSRP is desired. Currently, the only valid card ID is: master
  */
    public Option brandId(String brandId) {
    this.brandId = brandId;
    return this;
  }
  
  
    

  
  /**
   * Gets the acceptance type required for DSRPtransactions. Indicates the type(s) of cryptograms the merchant or service provider can accept. Valid types are: UCAF and/or ICC (see descriptions that follow). MasterPass passes the most secure selection (ICC) if both acceptance types are indicated.
   * 
   * @return	the acceptance type required for DSRPtransactions. Indicates the type(s) of cryptograms the merchant or service provider can accept. Valid types are: UCAF and/or ICC (see descriptions that follow). MasterPass passes the most secure selection (ICC) if both acceptance types are indicated.
   **/
  @XmlElement(name = "AcceptanceType")
  public AcceptanceTypeEnum getAcceptanceType() {
    return acceptanceType;
  }
  
  /**
  * Sets the acceptance type required for DSRPtransactions. Indicates the type(s) of cryptograms the merchant or service provider can accept. Valid types are: UCAF and/or ICC (see descriptions that follow). MasterPass passes the most secure selection (ICC) if both acceptance types are indicated.
  *
  * @param acceptanceType the acceptance type required for DSRPtransactions. Indicates the type(s) of cryptograms the merchant or service provider can accept. Valid types are: UCAF and/or ICC (see descriptions that follow). MasterPass passes the most secure selection (ICC) if both acceptance types are indicated.
  */
    public Option acceptanceType(AcceptanceTypeEnum acceptanceType) {
    this.acceptanceType = acceptanceType;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public Option extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Option option = (Option) o;
    return Objects.equals(brandId, option.brandId) &&
        Objects.equals(acceptanceType, option.acceptanceType) &&
        Objects.equals(extensionPoint, option.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(brandId, acceptanceType, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Option {\n");
    
    sb.append("    brandId: ").append(toIndentedString(brandId)).append("\n");
    sb.append("    acceptanceType: ").append(toIndentedString(acceptanceType)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


