package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import com.mastercard.masterpass.merchant.model.PairingDataType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.*;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods for different pairing data types arrays.
 **/
@Root(name = "PairingDataTypes")
@XmlRootElement (name = "PairingDataTypes")
public class PairingDataTypes   {
  
  @SerializedName("PairingDataType")
  @ElementList(name = "PairingDataType" , inline = true, entry = "PairingDataType")
  private List<PairingDataType> pairingDataType = new ArrayList<PairingDataType>();
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the pairing data type.
   * 
   * @return	the pairing data type.
   **/
  @XmlElement(name = "PairingDataType")
  public List<PairingDataType> getPairingDataType() {
    return pairingDataType;
  }
  
  /**
  * Sets the pairing data type.
  *
  * @param pairingDataType the pairing data type.
  */
    public PairingDataTypes pairingDataType(List<PairingDataType> pairingDataType) {
    this.pairingDataType = pairingDataType;
    return this;
  }
  
  
  /**
   * Sets the pairing data type.
   *
   * @param pairingDataType the pairing data type. Adds pairingDataType elements in a list. 
   *				  This is a optional method to add elements into the list. 
   */
  public PairingDataTypes pairingDataType(PairingDataType pairingDataType) {
     this.pairingDataType.add(pairingDataType);
     return this;
  }
  
  
  
    
    
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public PairingDataTypes extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PairingDataTypes pairingDataTypes = (PairingDataTypes) o;
    return Objects.equals(pairingDataType, pairingDataTypes.pairingDataType) &&
        Objects.equals(extensionPoint, pairingDataTypes.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(pairingDataType, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PairingDataTypes {\n");
    
    sb.append("    pairingDataType: ").append(toIndentedString(pairingDataType)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


