package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.CardTypes;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains types of payment extension.
 **/
@Root(name = "PaymentAcceptanceTypesExtension")
@XmlRootElement (name = "PaymentAcceptanceTypesExtension")
public class PaymentAcceptanceTypesExtension   {
  
  @SerializedName("CardTypes")
  @Element(name = "CardTypes", required = false)
  private CardTypes cardTypes = null;
  
  
  /**
   * Gets the card types for payment.
   * 
   * @return	the card types for payment.
   **/
  @XmlElement(name = "CardTypes")
  public CardTypes getCardTypes() {
    return cardTypes;
  }
  
  /**
  * Sets the card types for payment.
  *
  * @param cardTypes the card types for payment.
  */
    public PaymentAcceptanceTypesExtension cardTypes(CardTypes cardTypes) {
    this.cardTypes = cardTypes;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentAcceptanceTypesExtension paymentAcceptanceTypesExtension = (PaymentAcceptanceTypesExtension) o;
    return Objects.equals(cardTypes, paymentAcceptanceTypesExtension.cardTypes);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(cardTypes);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentAcceptanceTypesExtension {\n");
    
    sb.append("    cardTypes: ").append(toIndentedString(cardTypes)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


