package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.Installments;
import com.mastercard.masterpass.merchant.model.PaymentAcceptance;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods to set extensions such as installments, payment acceptance.
 **/
@Root(name = "PaymentOptionsExtensions")
@XmlRootElement (name = "PaymentOptionsExtensions")
public class PaymentOptionsExtensions   {
  
  @SerializedName("Installments")
  @Element(name = "Installments", required = false)
  private Installments installments = null;
  
  @SerializedName("PaymentAcceptance")
  @Element(name = "PaymentAcceptance", required = false)
  private PaymentAcceptance paymentAcceptance = null;
  
  
  /**
   * Gets the installments.
   * 
   * @return	the installments.
   **/
  @XmlElement(name = "Installments")
  public Installments getInstallments() {
    return installments;
  }
  
  /**
  * Sets the installments.
  *
  * @param installments the installments.
  */
    public PaymentOptionsExtensions installments(Installments installments) {
    this.installments = installments;
    return this;
  }
  
  
    

  
  /**
   * Gets the payment acceptance.
   * 
   * @return	the payment acceptance.
   **/
  @XmlElement(name = "PaymentAcceptance")
  public PaymentAcceptance getPaymentAcceptance() {
    return paymentAcceptance;
  }
  
  /**
  * Sets the payment acceptance.
  *
  * @param paymentAcceptance the payment acceptance.
  */
    public PaymentOptionsExtensions paymentAcceptance(PaymentAcceptance paymentAcceptance) {
    this.paymentAcceptance = paymentAcceptance;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentOptionsExtensions paymentOptionsExtensions = (PaymentOptionsExtensions) o;
    return Objects.equals(installments, paymentOptionsExtensions.installments) &&
        Objects.equals(paymentAcceptance, paymentOptionsExtensions.paymentAcceptance);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(installments, paymentAcceptance);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentOptionsExtensions {\n");
    
    sb.append("    installments: ").append(toIndentedString(installments)).append("\n");
    sb.append("    paymentAcceptance: ").append(toIndentedString(paymentAcceptance)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


