package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.Address;
import com.mastercard.masterpass.merchant.model.BaseCard;
import com.mastercard.masterpass.merchant.model.CardExtension;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



@Root(name = "PrecheckoutCard")
@XmlRootElement (name = "PrecheckoutCard")
public class PrecheckoutCard   {
  
  @SerializedName("LastFour")
  @Element(name = "LastFour", required = false)
  private String lastFour = null;
  
  @SerializedName("CardId")
  @Element(name = "CardId", required = false)
  private String cardId = null;
  
  @SerializedName("BrandId")
  @Element(name = "BrandId", required = false)
  private String brandId = null;
  
  @SerializedName("CardAlias")
  @Element(name = "CardAlias", required = false)
  private String cardAlias = null;
  
  @SerializedName("ExpiryMonth")
  @Element(name = "ExpiryMonth", required = false)
  private Integer expiryMonth = null;
  
  @SerializedName("SelectedAsDefault")
  @Element(name = "SelectedAsDefault", required = false)
  private Boolean selectedAsDefault = null;
  
  @SerializedName("BNBUnverified")
  @Element(name = "BNBUnverified", required = false)
  private Boolean bNBUnverified = null;
  
  @SerializedName("CardHolderName")
  @Element(name = "CardHolderName")
  private String cardHolderName = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private CardExtension extensionPoint = null;
  
  @SerializedName("BillingAddress")
  @Element(name = "BillingAddress", required = false)
  private Address billingAddress = null;
  
  @SerializedName("BrandName")
  @Element(name = "BrandName", required = false)
  private String brandName = null;
  
  @SerializedName("ExpiryYear")
  @Element(name = "ExpiryYear", required = false)
  private Integer expiryYear = null;
  
  
  /**
   * Gets the last four digits of card.
   * 
   * @return	the last four digits of card.
   **/
  @XmlElement(name = "LastFour")
  public String getLastFour() {
    return lastFour;
  }
  
  /**
  * Sets the last four digits of card.
  *
  * @param lastFour the last four digits of card.
  */
    public PrecheckoutCard lastFour(String lastFour) {
    this.lastFour = lastFour;
    return this;
  }
  
  
    

  
  /**
   * Gets the card id.
   * 
   * @return	the card id.
   **/
  @XmlElement(name = "CardId")
  public String getCardId() {
    return cardId;
  }
  
  /**
  * Sets the card id.
  *
  * @param cardId the card id.
  */
    public PrecheckoutCard cardId(String cardId) {
    this.cardId = cardId;
    return this;
  }
  
  
    

  
  /**
   * Gets the card brand id, for example, master for MasterCard.
   * 
   * @return	the card brand id, for example, master for MasterCard.
   **/
  @XmlElement(name = "BrandId")
  public String getBrandId() {
    return brandId;
  }
  
  /**
  * Sets the card brand id, for example, master for MasterCard.
  *
  * @param brandId the card brand id, for example, master for MasterCard.
  */
    public PrecheckoutCard brandId(String brandId) {
    this.brandId = brandId;
    return this;
  }
  
  
    

  
  /**
   * Gets the card alias.
   * 
   * @return	the card alias.
   **/
  @XmlElement(name = "CardAlias")
  public String getCardAlias() {
    return cardAlias;
  }
  
  /**
  * Sets the card alias.
  *
  * @param cardAlias the card alias.
  */
    public PrecheckoutCard cardAlias(String cardAlias) {
    this.cardAlias = cardAlias;
    return this;
  }
  
  
    

  
  /**
   * Gets the expiration month displayed on the payment card.
   * 
   * @return	the expiration month displayed on the payment card.
   **/
  @XmlElement(name = "ExpiryMonth")
  public Integer getExpiryMonth() {
    return expiryMonth;
  }
  
  /**
  * Sets the expiration month displayed on the payment card.
  *
  * @param expiryMonth the expiration month displayed on the payment card.
  */
    public PrecheckoutCard expiryMonth(Integer expiryMonth) {
    this.expiryMonth = expiryMonth;
    return this;
  }
  
  
    

  
  /**
   * Gets the default selection.
   * 
   * @return	the default selection.
   **/
  @XmlElement(name = "SelectedAsDefault")
  public Boolean getSelectedAsDefault() {
    return selectedAsDefault;
  }
  
  /**
  * Sets the default selection.
  *
  * @param selectedAsDefault the default selection.
  */
    public PrecheckoutCard selectedAsDefault(Boolean selectedAsDefault) {
    this.selectedAsDefault = selectedAsDefault;
    return this;
  }
  
  
    

  
  /**
   * Gets the flag for BNB unverified.
   * 
   * @return	the flag for BNB unverified.
   **/
  @XmlElement(name = "BNBUnverified")
  public Boolean getBNBUnverified() {
    return bNBUnverified;
  }
  
  /**
  * Sets the flag for BNB unverified.
  *
  * @param bNBUnverified the flag for BNB unverified.
  */
    public PrecheckoutCard bNBUnverified(Boolean bNBUnverified) {
    this.bNBUnverified = bNBUnverified;
    return this;
  }
  
  
    

  
  /**
   * Gets the cardholder name.
   * 
   * @return	the cardholder name.
   **/
  @XmlElement(name = "CardHolderName")
  public String getCardHolderName() {
    return cardHolderName;
  }
  
  /**
  * Sets the cardholder name.
  *
  * @param cardHolderName the cardholder name.
  */
    public PrecheckoutCard cardHolderName(String cardHolderName) {
    this.cardHolderName = cardHolderName;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public CardExtension getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public PrecheckoutCard extensionPoint(CardExtension extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Gets the billing address for the card holder.
   * 
   * @return	the billing address for the card holder.
   **/
  @XmlElement(name = "BillingAddress")
  public Address getBillingAddress() {
    return billingAddress;
  }
  
  /**
  * Sets the billing address for the card holder.
  *
  * @param billingAddress the billing address for the card holder.
  */
    public PrecheckoutCard billingAddress(Address billingAddress) {
    this.billingAddress = billingAddress;
    return this;
  }
  
  
    

  
  /**
   * Gets the card brand name, for example, MasterCard.
   * 
   * @return	the card brand name, for example, MasterCard.
   **/
  @XmlElement(name = "BrandName")
  public String getBrandName() {
    return brandName;
  }
  
  /**
  * Sets the card brand name, for example, MasterCard.
  *
  * @param brandName the card brand name, for example, MasterCard.
  */
    public PrecheckoutCard brandName(String brandName) {
    this.brandName = brandName;
    return this;
  }
  
  
    

  
  /**
   * Gets the expiration year displayed on the payment card.
   * 
   * @return	the expiration year displayed on the payment card.
   **/
  @XmlElement(name = "ExpiryYear")
  public Integer getExpiryYear() {
    return expiryYear;
  }
  
  /**
  * Sets the expiration year displayed on the payment card.
  *
  * @param expiryYear the expiration year displayed on the payment card.
  */
    public PrecheckoutCard expiryYear(Integer expiryYear) {
    this.expiryYear = expiryYear;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PrecheckoutCard precheckoutCard = (PrecheckoutCard) o;
    return Objects.equals(lastFour, precheckoutCard.lastFour) &&
        Objects.equals(cardId, precheckoutCard.cardId) &&
        Objects.equals(brandId, precheckoutCard.brandId) &&
        Objects.equals(cardAlias, precheckoutCard.cardAlias) &&
        Objects.equals(expiryMonth, precheckoutCard.expiryMonth) &&
        Objects.equals(selectedAsDefault, precheckoutCard.selectedAsDefault) &&
        Objects.equals(bNBUnverified, precheckoutCard.bNBUnverified) &&
        Objects.equals(cardHolderName, precheckoutCard.cardHolderName) &&
        Objects.equals(extensionPoint, precheckoutCard.extensionPoint) &&
        Objects.equals(billingAddress, precheckoutCard.billingAddress) &&
        Objects.equals(brandName, precheckoutCard.brandName) &&
        Objects.equals(expiryYear, precheckoutCard.expiryYear);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(lastFour, cardId, brandId, cardAlias, expiryMonth, selectedAsDefault, bNBUnverified, cardHolderName, extensionPoint, billingAddress, brandName, expiryYear);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PrecheckoutCard {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    lastFour: ").append(toIndentedString(lastFour)).append("\n");
    sb.append("    cardId: ").append(toIndentedString(cardId)).append("\n");
    sb.append("    brandId: ").append(toIndentedString(brandId)).append("\n");
    sb.append("    cardAlias: ").append(toIndentedString(cardAlias)).append("\n");
    sb.append("    expiryMonth: ").append(toIndentedString(expiryMonth)).append("\n");
    sb.append("    selectedAsDefault: ").append(toIndentedString(selectedAsDefault)).append("\n");
    sb.append("    bNBUnverified: ").append(toIndentedString(bNBUnverified)).append("\n");
    sb.append("    cardHolderName: ").append(toIndentedString(cardHolderName)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("    billingAddress: ").append(toIndentedString(billingAddress)).append("\n");
    sb.append("    brandName: ").append(toIndentedString(brandName)).append("\n");
    sb.append("    expiryYear: ").append(toIndentedString(expiryYear)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


