package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import com.mastercard.masterpass.merchant.model.PrecheckoutCard;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.*;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains different methods related to precheckout card.
 **/
@Root(name = "PrecheckoutCards")
@XmlRootElement (name = "PrecheckoutCards")
public class PrecheckoutCards   {
  
  @SerializedName("Card")
  @ElementList(name = "Card" , inline = true, entry = "Card", required = false)
  private List<PrecheckoutCard> card = new ArrayList<PrecheckoutCard>();
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the card information.
   * 
   * @return	the card information.
   **/
  @XmlElement(name = "Card")
  public List<PrecheckoutCard> getCard() {
    return card;
  }
  
  /**
  * Sets the card information.
  *
  * @param card the card information.
  */
    public PrecheckoutCards card(List<PrecheckoutCard> card) {
    this.card = card;
    return this;
  }
  
  
  /**
   * Sets the card information.
   *
   * @param card the card information. Adds card elements in a list. 
   *				  This is a optional method to add elements into the list. 
   */
  public PrecheckoutCards card(PrecheckoutCard card) {
     this.card.add(card);
     return this;
  }
  
  
  
    
    
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public PrecheckoutCards extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PrecheckoutCards precheckoutCards = (PrecheckoutCards) o;
    return Objects.equals(card, precheckoutCards.card) &&
        Objects.equals(extensionPoint, precheckoutCards.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(card, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PrecheckoutCards {\n");
    
    sb.append("    card: ").append(toIndentedString(card)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


