package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.Contact;
import com.mastercard.masterpass.merchant.model.Errors;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import com.mastercard.masterpass.merchant.model.PrecheckoutCards;
import com.mastercard.masterpass.merchant.model.PrecheckoutShippingAddresses;
import com.mastercard.masterpass.merchant.model.RewardPrograms;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains different methods for different types of precheckout data like card, contact, shipping address and reward program details.
 **/
@Root(name = "PrecheckoutData")
@XmlRootElement (name = "PrecheckoutData")
public class PrecheckoutData   {
  
  @SerializedName("Cards")
  @Element(name = "Cards")
  private PrecheckoutCards cards = null;
  
  @SerializedName("Contact")
  @Element(name = "Contact", required = false)
  private Contact contact = null;
  
  @SerializedName("ShippingAddresses")
  @Element(name = "ShippingAddresses", required = false)
  private PrecheckoutShippingAddresses shippingAddresses = null;
  
  @SerializedName("RewardPrograms")
  @Element(name = "RewardPrograms", required = false)
  private RewardPrograms rewardPrograms = null;
  
  @SerializedName("WalletName")
  @Element(name = "WalletName")
  private String walletName = null;
  
  @SerializedName("PrecheckoutTransactionId")
  @Element(name = "PrecheckoutTransactionId")
  private String precheckoutTransactionId = null;
  
  @SerializedName("ConsumerWalletId")
  @Element(name = "ConsumerWalletId")
  private String consumerWalletId = null;
  
  @SerializedName("Errors")
  @Element(name = "Errors", required = false)
  private Errors errors = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the cards.
   * 
   * @return	the cards.
   **/
  @XmlElement(name = "Cards")
  public PrecheckoutCards getCards() {
    return cards;
  }
  
  /**
  * Sets the cards.
  *
  * @param cards the cards.
  */
    public PrecheckoutData cards(PrecheckoutCards cards) {
    this.cards = cards;
    return this;
  }
  
  
    

  
  /**
   * Gets the contact details.
   * 
   * @return	the contact details.
   **/
  @XmlElement(name = "Contact")
  public Contact getContact() {
    return contact;
  }
  
  /**
  * Sets the contact details.
  *
  * @param contact the contact details.
  */
    public PrecheckoutData contact(Contact contact) {
    this.contact = contact;
    return this;
  }
  
  
    

  
  /**
   * Gets the shipping address details.
   * 
   * @return	the shipping address details.
   **/
  @XmlElement(name = "ShippingAddresses")
  public PrecheckoutShippingAddresses getShippingAddresses() {
    return shippingAddresses;
  }
  
  /**
  * Sets the shipping address details.
  *
  * @param shippingAddresses the shipping address details.
  */
    public PrecheckoutData shippingAddresses(PrecheckoutShippingAddresses shippingAddresses) {
    this.shippingAddresses = shippingAddresses;
    return this;
  }
  
  
    

  
  /**
   * Gets the reward program details.
   * 
   * @return	the reward program details.
   **/
  @XmlElement(name = "RewardPrograms")
  public RewardPrograms getRewardPrograms() {
    return rewardPrograms;
  }
  
  /**
  * Sets the reward program details.
  *
  * @param rewardPrograms the reward program details.
  */
    public PrecheckoutData rewardPrograms(RewardPrograms rewardPrograms) {
    this.rewardPrograms = rewardPrograms;
    return this;
  }
  
  
    

  
  /**
   * Gets the wallet name.
   * 
   * @return	the wallet name.
   **/
  @XmlElement(name = "WalletName")
  public String getWalletName() {
    return walletName;
  }
  
  /**
  * Sets the wallet name.
  *
  * @param walletName the wallet name.
  */
    public PrecheckoutData walletName(String walletName) {
    this.walletName = walletName;
    return this;
  }
  
  
    

  
  /**
   * Gets the precheckout transaction id.
   * 
   * @return	the precheckout transaction id.
   **/
  @XmlElement(name = "PrecheckoutTransactionId")
  public String getPrecheckoutTransactionId() {
    return precheckoutTransactionId;
  }
  
  /**
  * Sets the precheckout transaction id.
  *
  * @param precheckoutTransactionId the precheckout transaction id.
  */
    public PrecheckoutData precheckoutTransactionId(String precheckoutTransactionId) {
    this.precheckoutTransactionId = precheckoutTransactionId;
    return this;
  }
  
  
    

  
  /**
   * Gets the consumer wallet id.
   * 
   * @return	the consumer wallet id.
   **/
  @XmlElement(name = "ConsumerWalletId")
  public String getConsumerWalletId() {
    return consumerWalletId;
  }
  
  /**
  * Sets the consumer wallet id.
  *
  * @param consumerWalletId the consumer wallet id.
  */
    public PrecheckoutData consumerWalletId(String consumerWalletId) {
    this.consumerWalletId = consumerWalletId;
    return this;
  }
  
  
    

  
  /**
   * Gets the errors information.
   * 
   * @return	the errors information.
   **/
  @XmlElement(name = "Errors")
  public Errors getErrors() {
    return errors;
  }
  
  /**
  * Sets the errors information.
  *
  * @param errors the errors information.
  */
    public PrecheckoutData errors(Errors errors) {
    this.errors = errors;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public PrecheckoutData extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PrecheckoutData precheckoutData = (PrecheckoutData) o;
    return Objects.equals(cards, precheckoutData.cards) &&
        Objects.equals(contact, precheckoutData.contact) &&
        Objects.equals(shippingAddresses, precheckoutData.shippingAddresses) &&
        Objects.equals(rewardPrograms, precheckoutData.rewardPrograms) &&
        Objects.equals(walletName, precheckoutData.walletName) &&
        Objects.equals(precheckoutTransactionId, precheckoutData.precheckoutTransactionId) &&
        Objects.equals(consumerWalletId, precheckoutData.consumerWalletId) &&
        Objects.equals(errors, precheckoutData.errors) &&
        Objects.equals(extensionPoint, precheckoutData.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(cards, contact, shippingAddresses, rewardPrograms, walletName, precheckoutTransactionId, consumerWalletId, errors, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PrecheckoutData {\n");
    
    sb.append("    cards: ").append(toIndentedString(cards)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    shippingAddresses: ").append(toIndentedString(shippingAddresses)).append("\n");
    sb.append("    rewardPrograms: ").append(toIndentedString(rewardPrograms)).append("\n");
    sb.append("    walletName: ").append(toIndentedString(walletName)).append("\n");
    sb.append("    precheckoutTransactionId: ").append(toIndentedString(precheckoutTransactionId)).append("\n");
    sb.append("    consumerWalletId: ").append(toIndentedString(consumerWalletId)).append("\n");
    sb.append("    errors: ").append(toIndentedString(errors)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


