package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import com.mastercard.masterpass.merchant.model.PairingDataTypes;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods to set different parameters required to get the details of pairing details during precheckout.
 **/
@Root(name = "PrecheckoutDataRequest")
@XmlRootElement (name = "PrecheckoutDataRequest")
public class PrecheckoutDataRequest   {
  
  @SerializedName("PairingDataTypes")
  @Element(name = "PairingDataTypes")
  private PairingDataTypes pairingDataTypes = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the paring data types.
   * 
   * @return	the paring data types.
   **/
  @XmlElement(name = "PairingDataTypes")
  public PairingDataTypes getPairingDataTypes() {
    return pairingDataTypes;
  }
  
  /**
  * Sets the paring data types.
  *
  * @param pairingDataTypes the paring data types.
  */
    public PrecheckoutDataRequest pairingDataTypes(PairingDataTypes pairingDataTypes) {
    this.pairingDataTypes = pairingDataTypes;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public PrecheckoutDataRequest extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PrecheckoutDataRequest precheckoutDataRequest = (PrecheckoutDataRequest) o;
    return Objects.equals(pairingDataTypes, precheckoutDataRequest.pairingDataTypes) &&
        Objects.equals(extensionPoint, precheckoutDataRequest.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(pairingDataTypes, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PrecheckoutDataRequest {\n");
    
    sb.append("    pairingDataTypes: ").append(toIndentedString(pairingDataTypes)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


