package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import com.mastercard.masterpass.merchant.model.PrecheckoutData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class returns the precheckout data.
 **/
@Root(name = "PrecheckoutDataResponse")
@XmlRootElement (name = "PrecheckoutDataResponse")
public class PrecheckoutDataResponse   {
  
  @SerializedName("PrecheckoutData")
  @Element(name = "PrecheckoutData")
  private PrecheckoutData precheckoutData = null;
  
  @SerializedName("WalletPartnerLogoUrl")
  @Element(name = "WalletPartnerLogoUrl")
  private String walletPartnerLogoUrl = null;
  
  @SerializedName("MasterpassLogoUrl")
  @Element(name = "MasterpassLogoUrl")
  private String masterpassLogoUrl = null;
  
  @SerializedName("LongAccessToken")
  @Element(name = "LongAccessToken")
  private String longAccessToken = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the precheckout data details.
   * 
   * @return	the precheckout data details.
   **/
  @XmlElement(name = "PrecheckoutData")
  public PrecheckoutData getPrecheckoutData() {
    return precheckoutData;
  }
  
  /**
  * Sets the precheckout data details.
  *
  * @param precheckoutData the precheckout data details.
  */
    public PrecheckoutDataResponse precheckoutData(PrecheckoutData precheckoutData) {
    this.precheckoutData = precheckoutData;
    return this;
  }
  
  
    

  
  /**
   * Gets the wallet partner logo url.
   * 
   * @return	the wallet partner logo url.
   **/
  @XmlElement(name = "WalletPartnerLogoUrl")
  public String getWalletPartnerLogoUrl() {
    return walletPartnerLogoUrl;
  }
  
  /**
  * Sets the wallet partner logo url.
  *
  * @param walletPartnerLogoUrl the wallet partner logo url.
  */
    public PrecheckoutDataResponse walletPartnerLogoUrl(String walletPartnerLogoUrl) {
    this.walletPartnerLogoUrl = walletPartnerLogoUrl;
    return this;
  }
  
  
    

  
  /**
   * Gets the MasterPass logo url.
   * 
   * @return	the MasterPass logo url.
   **/
  @XmlElement(name = "MasterpassLogoUrl")
  public String getMasterpassLogoUrl() {
    return masterpassLogoUrl;
  }
  
  /**
  * Sets the MasterPass logo url.
  *
  * @param masterpassLogoUrl the MasterPass logo url.
  */
    public PrecheckoutDataResponse masterpassLogoUrl(String masterpassLogoUrl) {
    this.masterpassLogoUrl = masterpassLogoUrl;
    return this;
  }
  
  
    

  
  /**
   * Gets the long access token.
   * 
   * @return	the long access token.
   **/
  @XmlElement(name = "LongAccessToken")
  public String getLongAccessToken() {
    return longAccessToken;
  }
  
  /**
  * Sets the long access token.
  *
  * @param longAccessToken the long access token.
  */
    public PrecheckoutDataResponse longAccessToken(String longAccessToken) {
    this.longAccessToken = longAccessToken;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public PrecheckoutDataResponse extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PrecheckoutDataResponse precheckoutDataResponse = (PrecheckoutDataResponse) o;
    return Objects.equals(precheckoutData, precheckoutDataResponse.precheckoutData) &&
        Objects.equals(walletPartnerLogoUrl, precheckoutDataResponse.walletPartnerLogoUrl) &&
        Objects.equals(masterpassLogoUrl, precheckoutDataResponse.masterpassLogoUrl) &&
        Objects.equals(longAccessToken, precheckoutDataResponse.longAccessToken) &&
        Objects.equals(extensionPoint, precheckoutDataResponse.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(precheckoutData, walletPartnerLogoUrl, masterpassLogoUrl, longAccessToken, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PrecheckoutDataResponse {\n");
    
    sb.append("    precheckoutData: ").append(toIndentedString(precheckoutData)).append("\n");
    sb.append("    walletPartnerLogoUrl: ").append(toIndentedString(walletPartnerLogoUrl)).append("\n");
    sb.append("    masterpassLogoUrl: ").append(toIndentedString(masterpassLogoUrl)).append("\n");
    sb.append("    longAccessToken: ").append(toIndentedString(longAccessToken)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


