package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains the methods for reward program such as reward id, reward name etc along with program expiry details.
 **/
@Root(name = "PrecheckoutRewardProgram")
@XmlRootElement (name = "PrecheckoutRewardProgram")
public class PrecheckoutRewardProgram   {
  
  @SerializedName("RewardNumber")
  @Element(name = "RewardNumber")
  private String rewardNumber = null;
  
  @SerializedName("RewardId")
  @Element(name = "RewardId")
  private String rewardId = null;
  
  @SerializedName("RewardName")
  @Element(name = "RewardName", required = false)
  private String rewardName = null;
  
  @SerializedName("ExpiryMonth")
  @Element(name = "ExpiryMonth", required = false)
  private Integer expiryMonth = null;
  
  @SerializedName("ExpiryYear")
  @Element(name = "ExpiryYear", required = false)
  private Integer expiryYear = null;
  
  @SerializedName("RewardProgramId")
  @Element(name = "RewardProgramId")
  private String rewardProgramId = null;
  
  @SerializedName("RewardLogoUrl")
  @Element(name = "RewardLogoUrl", required = false)
  private String rewardLogoUrl = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the consumers reward number associated with the reward program.
   * 
   * @return	the consumers reward number associated with the reward program.
   **/
  @XmlElement(name = "RewardNumber")
  public String getRewardNumber() {
    return rewardNumber;
  }
  
  /**
  * Sets the consumers reward number associated with the reward program.
  *
  * @param rewardNumber the consumers reward number associated with the reward program.
  */
    public PrecheckoutRewardProgram rewardNumber(String rewardNumber) {
    this.rewardNumber = rewardNumber;
    return this;
  }
  
  
    

  
  /**
   * Gets the id associated with the reward program.
   * 
   * @return	the id associated with the reward program.
   **/
  @XmlElement(name = "RewardId")
  public String getRewardId() {
    return rewardId;
  }
  
  /**
  * Sets the id associated with the reward program.
  *
  * @param rewardId the id associated with the reward program.
  */
    public PrecheckoutRewardProgram rewardId(String rewardId) {
    this.rewardId = rewardId;
    return this;
  }
  
  
    

  
  /**
   * Gets the name of reward program.
   * 
   * @return	the name of reward program.
   **/
  @XmlElement(name = "RewardName")
  public String getRewardName() {
    return rewardName;
  }
  
  /**
  * Sets the name of reward program.
  *
  * @param rewardName the name of reward program.
  */
    public PrecheckoutRewardProgram rewardName(String rewardName) {
    this.rewardName = rewardName;
    return this;
  }
  
  
    

  
  /**
   * Gets the month when the reward program expires.
   * 
   * @return	the month when the reward program expires.
   **/
  @XmlElement(name = "ExpiryMonth")
  public Integer getExpiryMonth() {
    return expiryMonth;
  }
  
  /**
  * Sets the month when the reward program expires.
  *
  * @param expiryMonth the month when the reward program expires.
  */
    public PrecheckoutRewardProgram expiryMonth(Integer expiryMonth) {
    this.expiryMonth = expiryMonth;
    return this;
  }
  
  
    

  
  /**
   * Gets the year when the reward program expires.
   * 
   * @return	the year when the reward program expires.
   **/
  @XmlElement(name = "ExpiryYear")
  public Integer getExpiryYear() {
    return expiryYear;
  }
  
  /**
  * Sets the year when the reward program expires.
  *
  * @param expiryYear the year when the reward program expires.
  */
    public PrecheckoutRewardProgram expiryYear(Integer expiryYear) {
    this.expiryYear = expiryYear;
    return this;
  }
  
  
    

  
  /**
   * Gets the reward program id.
   * 
   * @return	the reward program id.
   **/
  @XmlElement(name = "RewardProgramId")
  public String getRewardProgramId() {
    return rewardProgramId;
  }
  
  /**
  * Sets the reward program id.
  *
  * @param rewardProgramId the reward program id.
  */
    public PrecheckoutRewardProgram rewardProgramId(String rewardProgramId) {
    this.rewardProgramId = rewardProgramId;
    return this;
  }
  
  
    

  
  /**
   * Gets the reward logo url.
   * 
   * @return	the reward logo url.
   **/
  @XmlElement(name = "RewardLogoUrl")
  public String getRewardLogoUrl() {
    return rewardLogoUrl;
  }
  
  /**
  * Sets the reward logo url.
  *
  * @param rewardLogoUrl the reward logo url.
  */
    public PrecheckoutRewardProgram rewardLogoUrl(String rewardLogoUrl) {
    this.rewardLogoUrl = rewardLogoUrl;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public PrecheckoutRewardProgram extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PrecheckoutRewardProgram precheckoutRewardProgram = (PrecheckoutRewardProgram) o;
    return Objects.equals(rewardNumber, precheckoutRewardProgram.rewardNumber) &&
        Objects.equals(rewardId, precheckoutRewardProgram.rewardId) &&
        Objects.equals(rewardName, precheckoutRewardProgram.rewardName) &&
        Objects.equals(expiryMonth, precheckoutRewardProgram.expiryMonth) &&
        Objects.equals(expiryYear, precheckoutRewardProgram.expiryYear) &&
        Objects.equals(rewardProgramId, precheckoutRewardProgram.rewardProgramId) &&
        Objects.equals(rewardLogoUrl, precheckoutRewardProgram.rewardLogoUrl) &&
        Objects.equals(extensionPoint, precheckoutRewardProgram.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(rewardNumber, rewardId, rewardName, expiryMonth, expiryYear, rewardProgramId, rewardLogoUrl, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PrecheckoutRewardProgram {\n");
    
    sb.append("    rewardNumber: ").append(toIndentedString(rewardNumber)).append("\n");
    sb.append("    rewardId: ").append(toIndentedString(rewardId)).append("\n");
    sb.append("    rewardName: ").append(toIndentedString(rewardName)).append("\n");
    sb.append("    expiryMonth: ").append(toIndentedString(expiryMonth)).append("\n");
    sb.append("    expiryYear: ").append(toIndentedString(expiryYear)).append("\n");
    sb.append("    rewardProgramId: ").append(toIndentedString(rewardProgramId)).append("\n");
    sb.append("    rewardLogoUrl: ").append(toIndentedString(rewardLogoUrl)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


