package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.Address;
import com.mastercard.masterpass.merchant.model.AddressExtensionPoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



@Root(name = "PrecheckoutShippingAddress")
@XmlRootElement (name = "PrecheckoutShippingAddress")
public class PrecheckoutShippingAddress   {
  
  @SerializedName("Line3")
  @Element(name = "Line3", required = false)
  private String line3 = null;
  
  @SerializedName("RecipientPhoneNumber")
  @Element(name = "RecipientPhoneNumber", required = false)
  private String recipientPhoneNumber = null;
  
  @SerializedName("Line2")
  @Element(name = "Line2", required = false)
  private String line2 = null;
  
  @SerializedName("Line1")
  @Element(name = "Line1")
  private String line1 = null;
  
  @SerializedName("CountrySubdivision")
  @Element(name = "CountrySubdivision", required = false)
  private String countrySubdivision = null;
  
  @SerializedName("RecipientName")
  @Element(name = "RecipientName", required = false)
  private String recipientName = null;
  
  @SerializedName("Country")
  @Element(name = "Country")
  private String country = null;
  
  @SerializedName("ShippingAlias")
  @Element(name = "ShippingAlias", required = false)
  private String shippingAlias = null;
  
  @SerializedName("City")
  @Element(name = "City")
  private String city = null;
  
  @SerializedName("AddressId")
  @Element(name = "AddressId", required = false)
  private String addressId = null;
  
  @SerializedName("PostalCode")
  @Element(name = "PostalCode", required = false)
  private String postalCode = null;
  
  @SerializedName("SelectedAsDefault")
  @Element(name = "SelectedAsDefault", required = false)
  private Boolean selectedAsDefault = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private AddressExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the address line 3 used to enter remaining address information if it does not fit in Line 1 and Line 2.
   * 
   * @return	the address line 3 used to enter remaining address information if it does not fit in Line 1 and Line 2.
   **/
  @XmlElement(name = "Line3")
  public String getLine3() {
    return line3;
  }
  
  /**
  * Sets the address line 3 used to enter remaining address information if it does not fit in Line 1 and Line 2.
  *
  * @param line3 the address line 3 used to enter remaining address information if it does not fit in Line 1 and Line 2.
  */
    public PrecheckoutShippingAddress line3(String line3) {
    this.line3 = line3;
    return this;
  }
  
  
    

  
  /**
   * Gets the recipient phone number.
   * 
   * @return	the recipient phone number.
   **/
  @XmlElement(name = "RecipientPhoneNumber")
  public String getRecipientPhoneNumber() {
    return recipientPhoneNumber;
  }
  
  /**
  * Sets the recipient phone number.
  *
  * @param recipientPhoneNumber the recipient phone number.
  */
    public PrecheckoutShippingAddress recipientPhoneNumber(String recipientPhoneNumber) {
    this.recipientPhoneNumber = recipientPhoneNumber;
    return this;
  }
  
  
    

  
  /**
   * Gets the address line 2 used for Apt Number, Suite Number, and so on.
   * 
   * @return	the address line 2 used for Apt Number, Suite Number, and so on.
   **/
  @XmlElement(name = "Line2")
  public String getLine2() {
    return line2;
  }
  
  /**
  * Sets the address line 2 used for Apt Number, Suite Number, and so on.
  *
  * @param line2 the address line 2 used for Apt Number, Suite Number, and so on.
  */
    public PrecheckoutShippingAddress line2(String line2) {
    this.line2 = line2;
    return this;
  }
  
  
    

  
  /**
   * Gets the address line 1 used for Street number and Street Name.
   * 
   * @return	the address line 1 used for Street number and Street Name.
   **/
  @XmlElement(name = "Line1")
  public String getLine1() {
    return line1;
  }
  
  /**
  * Sets the address line 1 used for Street number and Street Name.
  *
  * @param line1 the address line 1 used for Street number and Street Name.
  */
    public PrecheckoutShippingAddress line1(String line1) {
    this.line1 = line1;
    return this;
  }
  
  
    

  
  /**
   * Gets the cardholder's country subdivision. Defined by ISO 3166-1 alpha-2 digit code, for example, US-VA is Virginia, US-OH is Ohio
   * 
   * @return	the cardholder's country subdivision. Defined by ISO 3166-1 alpha-2 digit code, for example, US-VA is Virginia, US-OH is Ohio
   **/
  @XmlElement(name = "CountrySubdivision")
  public String getCountrySubdivision() {
    return countrySubdivision;
  }
  
  /**
  * Sets the cardholder's country subdivision. Defined by ISO 3166-1 alpha-2 digit code, for example, US-VA is Virginia, US-OH is Ohio
  *
  * @param countrySubdivision the cardholder's country subdivision. Defined by ISO 3166-1 alpha-2 digit code, for example, US-VA is Virginia, US-OH is Ohio
  */
    public PrecheckoutShippingAddress countrySubdivision(String countrySubdivision) {
    this.countrySubdivision = countrySubdivision;
    return this;
  }
  
  
    

  
  /**
   * Gets the recipient name.
   * 
   * @return	the recipient name.
   **/
  @XmlElement(name = "RecipientName")
  public String getRecipientName() {
    return recipientName;
  }
  
  /**
  * Sets the recipient name.
  *
  * @param recipientName the recipient name.
  */
    public PrecheckoutShippingAddress recipientName(String recipientName) {
    this.recipientName = recipientName;
    return this;
  }
  
  
    

  
  /**
   * Gets the cardholder's country. Defined by ISO 3166-1 alpha-2 digit country codes, for example, US is United States, AU is Australia, CA is Canada, GB is United Kingdom, and so on.
   * 
   * @return	the cardholder's country. Defined by ISO 3166-1 alpha-2 digit country codes, for example, US is United States, AU is Australia, CA is Canada, GB is United Kingdom, and so on.
   **/
  @XmlElement(name = "Country")
  public String getCountry() {
    return country;
  }
  
  /**
  * Sets the cardholder's country. Defined by ISO 3166-1 alpha-2 digit country codes, for example, US is United States, AU is Australia, CA is Canada, GB is United Kingdom, and so on.
  *
  * @param country the cardholder's country. Defined by ISO 3166-1 alpha-2 digit country codes, for example, US is United States, AU is Australia, CA is Canada, GB is United Kingdom, and so on.
  */
    public PrecheckoutShippingAddress country(String country) {
    this.country = country;
    return this;
  }
  
  
    

  
  /**
   * Gets the shipping alias.
   * 
   * @return	the shipping alias.
   **/
  @XmlElement(name = "ShippingAlias")
  public String getShippingAlias() {
    return shippingAlias;
  }
  
  /**
  * Sets the shipping alias.
  *
  * @param shippingAlias the shipping alias.
  */
    public PrecheckoutShippingAddress shippingAlias(String shippingAlias) {
    this.shippingAlias = shippingAlias;
    return this;
  }
  
  
    

  
  /**
   * Gets the cardholder's city.
   * 
   * @return	the cardholder's city.
   **/
  @XmlElement(name = "City")
  public String getCity() {
    return city;
  }
  
  /**
  * Sets the cardholder's city.
  *
  * @param city the cardholder's city.
  */
    public PrecheckoutShippingAddress city(String city) {
    this.city = city;
    return this;
  }
  
  
    

  
  /**
   * Gets the address Id.
   * 
   * @return	the address Id.
   **/
  @XmlElement(name = "AddressId")
  public String getAddressId() {
    return addressId;
  }
  
  /**
  * Sets the address Id.
  *
  * @param addressId the address Id.
  */
    public PrecheckoutShippingAddress addressId(String addressId) {
    this.addressId = addressId;
    return this;
  }
  
  
    

  
  /**
   * Gets the postal code or zip code appended to mailing address for the purpose of sorting mail.
   * 
   * @return	the postal code or zip code appended to mailing address for the purpose of sorting mail.
   **/
  @XmlElement(name = "PostalCode")
  public String getPostalCode() {
    return postalCode;
  }
  
  /**
  * Sets the postal code or zip code appended to mailing address for the purpose of sorting mail.
  *
  * @param postalCode the postal code or zip code appended to mailing address for the purpose of sorting mail.
  */
    public PrecheckoutShippingAddress postalCode(String postalCode) {
    this.postalCode = postalCode;
    return this;
  }
  
  
    

  
  /**
   * Gets the default selection.
   * 
   * @return	the default selection.
   **/
  @XmlElement(name = "SelectedAsDefault")
  public Boolean getSelectedAsDefault() {
    return selectedAsDefault;
  }
  
  /**
  * Sets the default selection.
  *
  * @param selectedAsDefault the default selection.
  */
    public PrecheckoutShippingAddress selectedAsDefault(Boolean selectedAsDefault) {
    this.selectedAsDefault = selectedAsDefault;
    return this;
  }
  
  
    

  
  /**
   * Gets the AddressExtensionPoint for additional information.
   * 
   * @return	the AddressExtensionPoint for additional information.
   **/
  @XmlElement(name = "ExtensionPoint")
  public AddressExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the AddressExtensionPoint for additional information.
  *
  * @param extensionPoint the AddressExtensionPoint for additional information.
  */
    public PrecheckoutShippingAddress extensionPoint(AddressExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PrecheckoutShippingAddress precheckoutShippingAddress = (PrecheckoutShippingAddress) o;
    return Objects.equals(line3, precheckoutShippingAddress.line3) &&
        Objects.equals(recipientPhoneNumber, precheckoutShippingAddress.recipientPhoneNumber) &&
        Objects.equals(line2, precheckoutShippingAddress.line2) &&
        Objects.equals(line1, precheckoutShippingAddress.line1) &&
        Objects.equals(countrySubdivision, precheckoutShippingAddress.countrySubdivision) &&
        Objects.equals(recipientName, precheckoutShippingAddress.recipientName) &&
        Objects.equals(country, precheckoutShippingAddress.country) &&
        Objects.equals(shippingAlias, precheckoutShippingAddress.shippingAlias) &&
        Objects.equals(city, precheckoutShippingAddress.city) &&
        Objects.equals(addressId, precheckoutShippingAddress.addressId) &&
        Objects.equals(postalCode, precheckoutShippingAddress.postalCode) &&
        Objects.equals(selectedAsDefault, precheckoutShippingAddress.selectedAsDefault) &&
        Objects.equals(extensionPoint, precheckoutShippingAddress.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(line3, recipientPhoneNumber, line2, line1, countrySubdivision, recipientName, country, shippingAlias, city, addressId, postalCode, selectedAsDefault, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PrecheckoutShippingAddress {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    line3: ").append(toIndentedString(line3)).append("\n");
    sb.append("    recipientPhoneNumber: ").append(toIndentedString(recipientPhoneNumber)).append("\n");
    sb.append("    line2: ").append(toIndentedString(line2)).append("\n");
    sb.append("    line1: ").append(toIndentedString(line1)).append("\n");
    sb.append("    countrySubdivision: ").append(toIndentedString(countrySubdivision)).append("\n");
    sb.append("    recipientName: ").append(toIndentedString(recipientName)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    shippingAlias: ").append(toIndentedString(shippingAlias)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    addressId: ").append(toIndentedString(addressId)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("    selectedAsDefault: ").append(toIndentedString(selectedAsDefault)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


