package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import com.mastercard.masterpass.merchant.model.PrecheckoutShippingAddress;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.*;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods to get pre checkout shipping address details.
 **/
@Root(name = "PrecheckoutShippingAddresses")
@XmlRootElement (name = "PrecheckoutShippingAddresses")
public class PrecheckoutShippingAddresses   {
  
  @SerializedName("ShippingAddress")
  @ElementList(name = "ShippingAddress" , inline = true, entry = "ShippingAddress", required = false)
  private List<PrecheckoutShippingAddress> shippingAddress = new ArrayList<PrecheckoutShippingAddress>();
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the shipping address details.
   * 
   * @return	the shipping address details.
   **/
  @XmlElement(name = "ShippingAddress")
  public List<PrecheckoutShippingAddress> getShippingAddress() {
    return shippingAddress;
  }
  
  /**
  * Sets the shipping address details.
  *
  * @param shippingAddress the shipping address details.
  */
    public PrecheckoutShippingAddresses shippingAddress(List<PrecheckoutShippingAddress> shippingAddress) {
    this.shippingAddress = shippingAddress;
    return this;
  }
  
  
  /**
   * Sets the shipping address details.
   *
   * @param shippingAddress the shipping address details. Adds shippingAddress elements in a list. 
   *				  This is a optional method to add elements into the list. 
   */
  public PrecheckoutShippingAddresses shippingAddress(PrecheckoutShippingAddress shippingAddress) {
     this.shippingAddress.add(shippingAddress);
     return this;
  }
  
  
  
    
    
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public PrecheckoutShippingAddresses extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PrecheckoutShippingAddresses precheckoutShippingAddresses = (PrecheckoutShippingAddresses) o;
    return Objects.equals(shippingAddress, precheckoutShippingAddresses.shippingAddress) &&
        Objects.equals(extensionPoint, precheckoutShippingAddresses.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(shippingAddress, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PrecheckoutShippingAddresses {\n");
    
    sb.append("    shippingAddress: ").append(toIndentedString(shippingAddress)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


