package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.PrivateData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods require to set private data details.
 **/
@Root(name = "PrivateDatas")
@XmlRootElement (name = "PrivateDatas")
public class PrivateDatas   {
  
  @SerializedName("PrivateData")
  @Element(name = "PrivateData", required = false)
  private PrivateData privateData = null;
  
  
  /**
   * Gets the private data.
   * 
   * @return	the private data.
   **/
  @XmlElement(name = "PrivateData")
  public PrivateData getPrivateData() {
    return privateData;
  }
  
  /**
  * Sets the private data.
  *
  * @param privateData the private data.
  */
    public PrivateDatas privateData(PrivateData privateData) {
    this.privateData = privateData;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PrivateDatas privateDatas = (PrivateDatas) o;
    return Objects.equals(privateData, privateDatas.privateData);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(privateData);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PrivateDatas {\n");
    
    sb.append("    privateData: ").append(toIndentedString(privateData)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


