package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods to get consumer reward program details.
 **/
@Root(name = "RewardProgram")
@XmlRootElement (name = "RewardProgram")
public class RewardProgram   {
  
  @SerializedName("RewardNumber")
  @Element(name = "RewardNumber")
  private String rewardNumber = null;
  
  @SerializedName("RewardId")
  @Element(name = "RewardId")
  private String rewardId = null;
  
  @SerializedName("RewardName")
  @Element(name = "RewardName", required = false)
  private String rewardName = null;
  
  @SerializedName("ExpiryMonth")
  @Element(name = "ExpiryMonth", required = false)
  private Integer expiryMonth = null;
  
  @SerializedName("ExpiryYear")
  @Element(name = "ExpiryYear", required = false)
  private Integer expiryYear = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the reward number.
   * 
   * @return	the reward number.
   **/
  @XmlElement(name = "RewardNumber")
  public String getRewardNumber() {
    return rewardNumber;
  }
  
  /**
  * Sets the reward number.
  *
  * @param rewardNumber the reward number.
  */
    public RewardProgram rewardNumber(String rewardNumber) {
    this.rewardNumber = rewardNumber;
    return this;
  }
  
  
    

  
  /**
   * Gets the reward Id.
   * 
   * @return	the reward Id.
   **/
  @XmlElement(name = "RewardId")
  public String getRewardId() {
    return rewardId;
  }
  
  /**
  * Sets the reward Id.
  *
  * @param rewardId the reward Id.
  */
    public RewardProgram rewardId(String rewardId) {
    this.rewardId = rewardId;
    return this;
  }
  
  
    

  
  /**
   * Gets the reward name.
   * 
   * @return	the reward name.
   **/
  @XmlElement(name = "RewardName")
  public String getRewardName() {
    return rewardName;
  }
  
  /**
  * Sets the reward name.
  *
  * @param rewardName the reward name.
  */
    public RewardProgram rewardName(String rewardName) {
    this.rewardName = rewardName;
    return this;
  }
  
  
    

  
  /**
   * Gets the expiry month.
   * 
   * @return	the expiry month.
   **/
  @XmlElement(name = "ExpiryMonth")
  public Integer getExpiryMonth() {
    return expiryMonth;
  }
  
  /**
  * Sets the expiry month.
  *
  * @param expiryMonth the expiry month.
  */
    public RewardProgram expiryMonth(Integer expiryMonth) {
    this.expiryMonth = expiryMonth;
    return this;
  }
  
  
    

  
  /**
   * Gets the expiry year.
   * 
   * @return	the expiry year.
   **/
  @XmlElement(name = "ExpiryYear")
  public Integer getExpiryYear() {
    return expiryYear;
  }
  
  /**
  * Sets the expiry year.
  *
  * @param expiryYear the expiry year.
  */
    public RewardProgram expiryYear(Integer expiryYear) {
    this.expiryYear = expiryYear;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public RewardProgram extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RewardProgram rewardProgram = (RewardProgram) o;
    return Objects.equals(rewardNumber, rewardProgram.rewardNumber) &&
        Objects.equals(rewardId, rewardProgram.rewardId) &&
        Objects.equals(rewardName, rewardProgram.rewardName) &&
        Objects.equals(expiryMonth, rewardProgram.expiryMonth) &&
        Objects.equals(expiryYear, rewardProgram.expiryYear) &&
        Objects.equals(extensionPoint, rewardProgram.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(rewardNumber, rewardId, rewardName, expiryMonth, expiryYear, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RewardProgram {\n");
    
    sb.append("    rewardNumber: ").append(toIndentedString(rewardNumber)).append("\n");
    sb.append("    rewardId: ").append(toIndentedString(rewardId)).append("\n");
    sb.append("    rewardName: ").append(toIndentedString(rewardName)).append("\n");
    sb.append("    expiryMonth: ").append(toIndentedString(expiryMonth)).append("\n");
    sb.append("    expiryYear: ").append(toIndentedString(expiryYear)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


