package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import com.mastercard.masterpass.merchant.model.PrecheckoutRewardProgram;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.*;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains consumer reward program information.
 **/
@Root(name = "RewardPrograms")
@XmlRootElement (name = "RewardPrograms")
public class RewardPrograms   {
  
  @SerializedName("RewardProgram")
  @ElementList(name = "RewardProgram" , inline = true, entry = "RewardProgram", required = false)
  private List<PrecheckoutRewardProgram> rewardProgram = new ArrayList<PrecheckoutRewardProgram>();
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the reward program details.
   * 
   * @return	the reward program details.
   **/
  @XmlElement(name = "RewardProgram")
  public List<PrecheckoutRewardProgram> getRewardProgram() {
    return rewardProgram;
  }
  
  /**
  * Sets the reward program details.
  *
  * @param rewardProgram the reward program details.
  */
    public RewardPrograms rewardProgram(List<PrecheckoutRewardProgram> rewardProgram) {
    this.rewardProgram = rewardProgram;
    return this;
  }
  
  
  /**
   * Sets the reward program details.
   *
   * @param rewardProgram the reward program details. Adds rewardProgram elements in a list. 
   *				  This is a optional method to add elements into the list. 
   */
  public RewardPrograms rewardProgram(PrecheckoutRewardProgram rewardProgram) {
     this.rewardProgram.add(rewardProgram);
     return this;
  }
  
  
  
    
    
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public RewardPrograms extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RewardPrograms rewardPrograms = (RewardPrograms) o;
    return Objects.equals(rewardProgram, rewardPrograms.rewardProgram) &&
        Objects.equals(extensionPoint, rewardPrograms.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(rewardProgram, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RewardPrograms {\n");
    
    sb.append("    rewardProgram: ").append(toIndentedString(rewardProgram)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


