package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import com.mastercard.masterpass.merchant.model.Wallet;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods require to set checkout details during DSRP.
 **/
@Root(name = "RiskDecisioning")
@XmlRootElement (name = "RiskDecisioning")
public class RiskDecisioning   {
  
  @SerializedName("Wallet")
  @Element(name = "Wallet", required = false)
  private Wallet wallet = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the Wallet information.
   * 
   * @return	the Wallet information.
   **/
  @XmlElement(name = "Wallet")
  public Wallet getWallet() {
    return wallet;
  }
  
  /**
  * Sets the Wallet information.
  *
  * @param wallet the Wallet information.
  */
    public RiskDecisioning wallet(Wallet wallet) {
    this.wallet = wallet;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public RiskDecisioning extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RiskDecisioning riskDecisioning = (RiskDecisioning) o;
    return Objects.equals(wallet, riskDecisioning.wallet) &&
        Objects.equals(extensionPoint, riskDecisioning.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(wallet, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RiskDecisioning {\n");
    
    sb.append("    wallet: ").append(toIndentedString(wallet)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


