package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * the decryption service request for android SDK.
 **/
@Root(name = "SessionKeySigningRequest")
@XmlRootElement (name = "SessionKeySigningRequest")
public class SessionKeySigningRequest   {
  
  @SerializedName("AppId")
  @Element(name = "AppId")
  private String appId = null;
  
  @SerializedName("AppVersion")
  @Element(name = "AppVersion")
  private String appVersion = null;
  
  @SerializedName("AppSigningPublicKey")
  @Element(name = "AppSigningPublicKey")
  private String appSigningPublicKey = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the AppId details.
   * 
   * @return	the AppId details.
   **/
  @XmlElement(name = "AppId")
  public String getAppId() {
    return appId;
  }
  
  /**
  * Sets the AppId details.
  *
  * @param appId the AppId details.
  */
    public SessionKeySigningRequest appId(String appId) {
    this.appId = appId;
    return this;
  }
  
  
    

  
  /**
   * Gets the AppVersion details.
   * 
   * @return	the AppVersion details.
   **/
  @XmlElement(name = "AppVersion")
  public String getAppVersion() {
    return appVersion;
  }
  
  /**
  * Sets the AppVersion details.
  *
  * @param appVersion the AppVersion details.
  */
    public SessionKeySigningRequest appVersion(String appVersion) {
    this.appVersion = appVersion;
    return this;
  }
  
  
    

  
  /**
   * Gets the AppSigningPublicKey details.
   * 
   * @return	the AppSigningPublicKey details.
   **/
  @XmlElement(name = "AppSigningPublicKey")
  public String getAppSigningPublicKey() {
    return appSigningPublicKey;
  }
  
  /**
  * Sets the AppSigningPublicKey details.
  *
  * @param appSigningPublicKey the AppSigningPublicKey details.
  */
    public SessionKeySigningRequest appSigningPublicKey(String appSigningPublicKey) {
    this.appSigningPublicKey = appSigningPublicKey;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public SessionKeySigningRequest extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SessionKeySigningRequest sessionKeySigningRequest = (SessionKeySigningRequest) o;
    return Objects.equals(appId, sessionKeySigningRequest.appId) &&
        Objects.equals(appVersion, sessionKeySigningRequest.appVersion) &&
        Objects.equals(appSigningPublicKey, sessionKeySigningRequest.appSigningPublicKey) &&
        Objects.equals(extensionPoint, sessionKeySigningRequest.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(appId, appVersion, appSigningPublicKey, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SessionKeySigningRequest {\n");
    
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    appVersion: ").append(toIndentedString(appVersion)).append("\n");
    sb.append("    appSigningPublicKey: ").append(toIndentedString(appSigningPublicKey)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


