package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.Address;
import com.mastercard.masterpass.merchant.model.AddressExtensionPoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



@Root(name = "ShippingAddress")
@XmlRootElement (name = "ShippingAddress")
public class ShippingAddress   {
  
  @SerializedName("RecipientPhoneNumber")
  @Element(name = "RecipientPhoneNumber", required = false)
  private String recipientPhoneNumber = null;
  
  @SerializedName("Line3")
  @Element(name = "Line3", required = false)
  private String line3 = null;
  
  @SerializedName("Line2")
  @Element(name = "Line2", required = false)
  private String line2 = null;
  
  @SerializedName("Line1")
  @Element(name = "Line1")
  private String line1 = null;
  
  @SerializedName("PostalCode")
  @Element(name = "PostalCode", required = false)
  private String postalCode = null;
  
  @SerializedName("CountrySubdivision")
  @Element(name = "CountrySubdivision", required = false)
  private String countrySubdivision = null;
  
  @SerializedName("RecipientName")
  @Element(name = "RecipientName", required = false)
  private String recipientName = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private AddressExtensionPoint extensionPoint = null;
  
  @SerializedName("Country")
  @Element(name = "Country")
  private String country = null;
  
  @SerializedName("City")
  @Element(name = "City")
  private String city = null;
  
  
  /**
   * Gets the phone number of the person set to receive the shipped order.
   * 
   * @return	the phone number of the person set to receive the shipped order.
   **/
  @XmlElement(name = "RecipientPhoneNumber")
  public String getRecipientPhoneNumber() {
    return recipientPhoneNumber;
  }
  
  /**
  * Sets the phone number of the person set to receive the shipped order.
  *
  * @param recipientPhoneNumber the phone number of the person set to receive the shipped order.
  */
    public ShippingAddress recipientPhoneNumber(String recipientPhoneNumber) {
    this.recipientPhoneNumber = recipientPhoneNumber;
    return this;
  }
  
  
    

  
  /**
   * Gets the address line 3 used to enter remaining address information if it does not fit in Line 1 and Line 2.
   * 
   * @return	the address line 3 used to enter remaining address information if it does not fit in Line 1 and Line 2.
   **/
  @XmlElement(name = "Line3")
  public String getLine3() {
    return line3;
  }
  
  /**
  * Sets the address line 3 used to enter remaining address information if it does not fit in Line 1 and Line 2.
  *
  * @param line3 the address line 3 used to enter remaining address information if it does not fit in Line 1 and Line 2.
  */
    public ShippingAddress line3(String line3) {
    this.line3 = line3;
    return this;
  }
  
  
    

  
  /**
   * Gets the address line 2 used for Apt Number, Suite Number, and so on.
   * 
   * @return	the address line 2 used for Apt Number, Suite Number, and so on.
   **/
  @XmlElement(name = "Line2")
  public String getLine2() {
    return line2;
  }
  
  /**
  * Sets the address line 2 used for Apt Number, Suite Number, and so on.
  *
  * @param line2 the address line 2 used for Apt Number, Suite Number, and so on.
  */
    public ShippingAddress line2(String line2) {
    this.line2 = line2;
    return this;
  }
  
  
    

  
  /**
   * Gets the address line 1 used for Street number and Street Name.
   * 
   * @return	the address line 1 used for Street number and Street Name.
   **/
  @XmlElement(name = "Line1")
  public String getLine1() {
    return line1;
  }
  
  /**
  * Sets the address line 1 used for Street number and Street Name.
  *
  * @param line1 the address line 1 used for Street number and Street Name.
  */
    public ShippingAddress line1(String line1) {
    this.line1 = line1;
    return this;
  }
  
  
    

  
  /**
   * Gets the postal code or zip code appended to mailing address for the purpose of sorting mail.
   * 
   * @return	the postal code or zip code appended to mailing address for the purpose of sorting mail.
   **/
  @XmlElement(name = "PostalCode")
  public String getPostalCode() {
    return postalCode;
  }
  
  /**
  * Sets the postal code or zip code appended to mailing address for the purpose of sorting mail.
  *
  * @param postalCode the postal code or zip code appended to mailing address for the purpose of sorting mail.
  */
    public ShippingAddress postalCode(String postalCode) {
    this.postalCode = postalCode;
    return this;
  }
  
  
    

  
  /**
   * Gets the cardholder's country subdivision. Defined by ISO 3166-1 alpha-2 digit code, for example, US-VA is Virginia, US-OH is Ohio
   * 
   * @return	the cardholder's country subdivision. Defined by ISO 3166-1 alpha-2 digit code, for example, US-VA is Virginia, US-OH is Ohio
   **/
  @XmlElement(name = "CountrySubdivision")
  public String getCountrySubdivision() {
    return countrySubdivision;
  }
  
  /**
  * Sets the cardholder's country subdivision. Defined by ISO 3166-1 alpha-2 digit code, for example, US-VA is Virginia, US-OH is Ohio
  *
  * @param countrySubdivision the cardholder's country subdivision. Defined by ISO 3166-1 alpha-2 digit code, for example, US-VA is Virginia, US-OH is Ohio
  */
    public ShippingAddress countrySubdivision(String countrySubdivision) {
    this.countrySubdivision = countrySubdivision;
    return this;
  }
  
  
    

  
  /**
   * Gets the name of person set to receive the shipped order.
   * 
   * @return	the name of person set to receive the shipped order.
   **/
  @XmlElement(name = "RecipientName")
  public String getRecipientName() {
    return recipientName;
  }
  
  /**
  * Sets the name of person set to receive the shipped order.
  *
  * @param recipientName the name of person set to receive the shipped order.
  */
    public ShippingAddress recipientName(String recipientName) {
    this.recipientName = recipientName;
    return this;
  }
  
  
    

  
  /**
   * Gets the AddressExtensionPoint for additional information.
   * 
   * @return	the AddressExtensionPoint for additional information.
   **/
  @XmlElement(name = "ExtensionPoint")
  public AddressExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the AddressExtensionPoint for additional information.
  *
  * @param extensionPoint the AddressExtensionPoint for additional information.
  */
    public ShippingAddress extensionPoint(AddressExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Gets the cardholder's country. Defined by ISO 3166-1 alpha-2 digit country codes, for example, US is United States, AU is Australia, CA is Canada, GB is United Kingdom, and so on.
   * 
   * @return	the cardholder's country. Defined by ISO 3166-1 alpha-2 digit country codes, for example, US is United States, AU is Australia, CA is Canada, GB is United Kingdom, and so on.
   **/
  @XmlElement(name = "Country")
  public String getCountry() {
    return country;
  }
  
  /**
  * Sets the cardholder's country. Defined by ISO 3166-1 alpha-2 digit country codes, for example, US is United States, AU is Australia, CA is Canada, GB is United Kingdom, and so on.
  *
  * @param country the cardholder's country. Defined by ISO 3166-1 alpha-2 digit country codes, for example, US is United States, AU is Australia, CA is Canada, GB is United Kingdom, and so on.
  */
    public ShippingAddress country(String country) {
    this.country = country;
    return this;
  }
  
  
    

  
  /**
   * Gets the cardholder's city.
   * 
   * @return	the cardholder's city.
   **/
  @XmlElement(name = "City")
  public String getCity() {
    return city;
  }
  
  /**
  * Sets the cardholder's city.
  *
  * @param city the cardholder's city.
  */
    public ShippingAddress city(String city) {
    this.city = city;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ShippingAddress shippingAddress = (ShippingAddress) o;
    return Objects.equals(recipientPhoneNumber, shippingAddress.recipientPhoneNumber) &&
        Objects.equals(line3, shippingAddress.line3) &&
        Objects.equals(line2, shippingAddress.line2) &&
        Objects.equals(line1, shippingAddress.line1) &&
        Objects.equals(postalCode, shippingAddress.postalCode) &&
        Objects.equals(countrySubdivision, shippingAddress.countrySubdivision) &&
        Objects.equals(recipientName, shippingAddress.recipientName) &&
        Objects.equals(extensionPoint, shippingAddress.extensionPoint) &&
        Objects.equals(country, shippingAddress.country) &&
        Objects.equals(city, shippingAddress.city);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(recipientPhoneNumber, line3, line2, line1, postalCode, countrySubdivision, recipientName, extensionPoint, country, city);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ShippingAddress {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    recipientPhoneNumber: ").append(toIndentedString(recipientPhoneNumber)).append("\n");
    sb.append("    line3: ").append(toIndentedString(line3)).append("\n");
    sb.append("    line2: ").append(toIndentedString(line2)).append("\n");
    sb.append("    line1: ").append(toIndentedString(line1)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("    countrySubdivision: ").append(toIndentedString(countrySubdivision)).append("\n");
    sb.append("    recipientName: ").append(toIndentedString(recipientName)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


