package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import com.mastercard.masterpass.merchant.model.ShoppingCartItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.*;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains various methods for to set different shopping cart parameters required for Shopping Cart Service.
 **/
@Root(name = "ShoppingCart")
@XmlRootElement (name = "ShoppingCart")
public class ShoppingCart   {
  
  @SerializedName("CurrencyCode")
  @Element(name = "CurrencyCode", required = false)
  private String currencyCode = null;
  
  @SerializedName("Subtotal")
  @Element(name = "Subtotal")
  private Long subtotal = null;
  
  @SerializedName("ShoppingCartItem")
  @ElementList(name = "ShoppingCartItem" , inline = true, entry = "ShoppingCartItem", required = false)
  private List<ShoppingCartItem> shoppingCartItem = new ArrayList<ShoppingCartItem>();
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the currency code defined by ISO 4217. Its should be exactly three characters, such as, USD for US Dollars. All MonetaryValues will be modified by the CurrencyCode.
   * 
   * @return	the currency code defined by ISO 4217. Its should be exactly three characters, such as, USD for US Dollars. All MonetaryValues will be modified by the CurrencyCode.
   **/
  @XmlElement(name = "CurrencyCode")
  public String getCurrencyCode() {
    return currencyCode;
  }
  
  /**
  * Sets the currency code defined by ISO 4217. Its should be exactly three characters, such as, USD for US Dollars. All MonetaryValues will be modified by the CurrencyCode.
  *
  * @param currencyCode the currency code defined by ISO 4217. Its should be exactly three characters, such as, USD for US Dollars. All MonetaryValues will be modified by the CurrencyCode.
  */
    public ShoppingCart currencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }
  
  
    

  
  /**
   * Gets the total sum of all the items in the cart excluding shipping, handling and tax. Integer without the decimal, for example, USD 119.00 will be 11900.
   * 
   * @return	the total sum of all the items in the cart excluding shipping, handling and tax. Integer without the decimal, for example, USD 119.00 will be 11900.
   **/
  @XmlElement(name = "Subtotal")
  public Long getSubtotal() {
    return subtotal;
  }
  
  /**
  * Sets the total sum of all the items in the cart excluding shipping, handling and tax. Integer without the decimal, for example, USD 119.00 will be 11900.
  *
  * @param subtotal the total sum of all the items in the cart excluding shipping, handling and tax. Integer without the decimal, for example, USD 119.00 will be 11900.
  */
    public ShoppingCart subtotal(Long subtotal) {
    this.subtotal = subtotal;
    return this;
  }
  
  
    

  
  /**
   * Gets the details of a single shopping cart item.
   * 
   * @return	the details of a single shopping cart item.
   **/
  @XmlElement(name = "ShoppingCartItem")
  public List<ShoppingCartItem> getShoppingCartItem() {
    return shoppingCartItem;
  }
  
  /**
  * Sets the details of a single shopping cart item.
  *
  * @param shoppingCartItem the details of a single shopping cart item.
  */
    public ShoppingCart shoppingCartItem(List<ShoppingCartItem> shoppingCartItem) {
    this.shoppingCartItem = shoppingCartItem;
    return this;
  }
  
  
  /**
   * Sets the details of a single shopping cart item.
   *
   * @param shoppingCartItem the details of a single shopping cart item. Adds shoppingCartItem elements in a list. 
   *				  This is a optional method to add elements into the list. 
   */
  public ShoppingCart shoppingCartItem(ShoppingCartItem shoppingCartItem) {
     this.shoppingCartItem.add(shoppingCartItem);
     return this;
  }
  
  
  
    
    
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public ShoppingCart extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ShoppingCart shoppingCart = (ShoppingCart) o;
    return Objects.equals(currencyCode, shoppingCart.currencyCode) &&
        Objects.equals(subtotal, shoppingCart.subtotal) &&
        Objects.equals(shoppingCartItem, shoppingCart.shoppingCartItem) &&
        Objects.equals(extensionPoint, shoppingCart.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(currencyCode, subtotal, shoppingCartItem, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ShoppingCart {\n");
    
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    subtotal: ").append(toIndentedString(subtotal)).append("\n");
    sb.append("    shoppingCartItem: ").append(toIndentedString(shoppingCartItem)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


