package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains various methods for to set shopping cart items required for Shopping Cart Service.
 **/
@Root(name = "ShoppingCartItem")
@XmlRootElement (name = "ShoppingCartItem")
public class ShoppingCartItem   {
  
  @SerializedName("Description")
  @Element(name = "Description")
  private String description = null;
  
  @SerializedName("Quantity")
  @Element(name = "Quantity")
  private Integer quantity = null;
  
  @SerializedName("Value")
  @Element(name = "Value")
  private Long value = null;
  
  @SerializedName("ImageURL")
  @Element(name = "ImageURL", required = false)
  private String imageURL = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the description shopping cart item.
   * 
   * @return	the description shopping cart item.
   **/
  @XmlElement(name = "Description")
  public String getDescription() {
    return description;
  }
  
  /**
  * Sets the description shopping cart item.
  *
  * @param description the description shopping cart item.
  */
    public ShoppingCartItem description(String description) {
    this.description = description;
    return this;
  }
  
  
    

  
  /**
   * Gets the number of shopping cart item.
   * 
   * @return	the number of shopping cart item.
   **/
  @XmlElement(name = "Quantity")
  public Integer getQuantity() {
    return quantity;
  }
  
  /**
  * Sets the number of shopping cart item.
  *
  * @param quantity the number of shopping cart item.
  */
    public ShoppingCartItem quantity(Integer quantity) {
    this.quantity = quantity;
    return this;
  }
  
  
    

  
  /**
   * Gets the price or monetary value of a single shopping cart item. Cost * Quantity. Integer without decimal, for example, USD 100.00 is 10000.
   * 
   * @return	the price or monetary value of a single shopping cart item. Cost * Quantity. Integer without decimal, for example, USD 100.00 is 10000.
   **/
  @XmlElement(name = "Value")
  public Long getValue() {
    return value;
  }
  
  /**
  * Sets the price or monetary value of a single shopping cart item. Cost * Quantity. Integer without decimal, for example, USD 100.00 is 10000.
  *
  * @param value the price or monetary value of a single shopping cart item. Cost * Quantity. Integer without decimal, for example, USD 100.00 is 10000.
  */
    public ShoppingCartItem value(Long value) {
    this.value = value;
    return this;
  }
  
  
    

  
  /**
   * Gets the image URL of the shopping cart item.
   * 
   * @return	the image URL of the shopping cart item.
   **/
  @XmlElement(name = "ImageURL")
  public String getImageURL() {
    return imageURL;
  }
  
  /**
  * Sets the image URL of the shopping cart item.
  *
  * @param imageURL the image URL of the shopping cart item.
  */
    public ShoppingCartItem imageURL(String imageURL) {
    this.imageURL = imageURL;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public ShoppingCartItem extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ShoppingCartItem shoppingCartItem = (ShoppingCartItem) o;
    return Objects.equals(description, shoppingCartItem.description) &&
        Objects.equals(quantity, shoppingCartItem.quantity) &&
        Objects.equals(value, shoppingCartItem.value) &&
        Objects.equals(imageURL, shoppingCartItem.imageURL) &&
        Objects.equals(extensionPoint, shoppingCartItem.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(description, quantity, value, imageURL, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ShoppingCartItem {\n");
    
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    imageURL: ").append(toIndentedString(imageURL)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


