package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.ShoppingCart;
import com.mastercard.masterpass.merchant.model.ShoppingCartRequestExtensionPoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains various methods for to set different shopping cart request parameters required for Shopping Cart Service.
 **/
@Root(name = "ShoppingCartRequest")
@XmlRootElement (name = "ShoppingCartRequest")
public class ShoppingCartRequest   {
  
  @SerializedName("OAuthToken")
  @Element(name = "OAuthToken")
  private String oAuthToken = null;
  
  @SerializedName("ShoppingCart")
  @Element(name = "ShoppingCart")
  private ShoppingCart shoppingCart = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ShoppingCartRequestExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the request Token (oauth_token) returned by call to the request_token API.
   * 
   * @return	the request Token (oauth_token) returned by call to the request_token API.
   **/
  @XmlElement(name = "OAuthToken")
  public String getOAuthToken() {
    return oAuthToken;
  }
  
  /**
  * Sets the request Token (oauth_token) returned by call to the request_token API.
  *
  * @param oAuthToken the request Token (oauth_token) returned by call to the request_token API.
  */
    public ShoppingCartRequest oAuthToken(String oAuthToken) {
    this.oAuthToken = oAuthToken;
    return this;
  }
  
  
    

  
  /**
   * Gets the Shopping Cart details.
   * 
   * @return	the Shopping Cart details.
   **/
  @XmlElement(name = "ShoppingCart")
  public ShoppingCart getShoppingCart() {
    return shoppingCart;
  }
  
  /**
  * Sets the Shopping Cart details.
  *
  * @param shoppingCart the Shopping Cart details.
  */
    public ShoppingCartRequest shoppingCart(ShoppingCart shoppingCart) {
    this.shoppingCart = shoppingCart;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ShoppingCartRequestExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public ShoppingCartRequest extensionPoint(ShoppingCartRequestExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ShoppingCartRequest shoppingCartRequest = (ShoppingCartRequest) o;
    return Objects.equals(oAuthToken, shoppingCartRequest.oAuthToken) &&
        Objects.equals(shoppingCart, shoppingCartRequest.shoppingCart) &&
        Objects.equals(extensionPoint, shoppingCartRequest.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(oAuthToken, shoppingCart, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ShoppingCartRequest {\n");
    
    sb.append("    oAuthToken: ").append(toIndentedString(oAuthToken)).append("\n");
    sb.append("    shoppingCart: ").append(toIndentedString(shoppingCart)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


