package com.mastercard.masterpass.merchant.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.masterpass.merchant.model.ExtensionPoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains token request information.
 **/
@Root(name = "Tokenization")
@XmlRootElement (name = "Tokenization")
public class Tokenization   {
  
  @SerializedName("FPanSuffix")
  @Element(name = "FPanSuffix")
  private String fPanSuffix = null;
  
  @SerializedName("TokenRequestorId")
  @Element(name = "TokenRequestorId")
  private String tokenRequestorId = null;
  
  @SerializedName("ExtensionPoint")
  @Element(name = "ExtensionPoint", required = false)
  private ExtensionPoint extensionPoint = null;
  
  
  /**
   * Gets the pan suffix.
   * 
   * @return	the pan suffix.
   **/
  @XmlElement(name = "FPanSuffix")
  public String getFPanSuffix() {
    return fPanSuffix;
  }
  
  /**
  * Sets the pan suffix.
  *
  * @param fPanSuffix the pan suffix.
  */
    public Tokenization fPanSuffix(String fPanSuffix) {
    this.fPanSuffix = fPanSuffix;
    return this;
  }
  
  
    

  
  /**
   * Gets the token request or id.
   * 
   * @return	the token request or id.
   **/
  @XmlElement(name = "TokenRequestorId")
  public String getTokenRequestorId() {
    return tokenRequestorId;
  }
  
  /**
  * Sets the token request or id.
  *
  * @param tokenRequestorId the token request or id.
  */
    public Tokenization tokenRequestorId(String tokenRequestorId) {
    this.tokenRequestorId = tokenRequestorId;
    return this;
  }
  
  
    

  
  /**
   * Gets the ExtensionPoint for future enhancement.
   * 
   * @return	the ExtensionPoint for future enhancement.
   **/
  @XmlElement(name = "ExtensionPoint")
  public ExtensionPoint getExtensionPoint() {
    return extensionPoint;
  }
  
  /**
  * Sets the ExtensionPoint for future enhancement.
  *
  * @param extensionPoint the ExtensionPoint for future enhancement.
  */
    public Tokenization extensionPoint(ExtensionPoint extensionPoint) {
    this.extensionPoint = extensionPoint;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Tokenization tokenization = (Tokenization) o;
    return Objects.equals(fPanSuffix, tokenization.fPanSuffix) &&
        Objects.equals(tokenRequestorId, tokenization.tokenRequestorId) &&
        Objects.equals(extensionPoint, tokenization.extensionPoint);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(fPanSuffix, tokenRequestorId, extensionPoint);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Tokenization {\n");
    
    sb.append("    fPanSuffix: ").append(toIndentedString(fPanSuffix)).append("\n");
    sb.append("    tokenRequestorId: ").append(toIndentedString(tokenRequestorId)).append("\n");
    sb.append("    extensionPoint: ").append(toIndentedString(extensionPoint)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


