package com.mastercard.merchant.checkout;

import com.mastercard.merchant.checkout.model.PaymentData;

import com.mastercard.sdk.core.invoker.ApiClient;
import com.mastercard.sdk.core.util.ServiceRequest;
import com.mastercard.sdk.core.util.QueryParams;
import com.mastercard.sdk.core.exceptions.MasterpassErrorHandler;
import com.mastercard.sdk.core.ApiConfig;
import com.mastercard.sdk.core.MasterCardApiConfig;
import com.mastercard.merchant.checkout.impl.APITrackerImpl;

public class PaymentDataApi {

 /**
   * PaymentData Service
   * <p>This service is used to retrieve the consumer&#39;s payment, shipping address, and recipient personal information from Masterpass.</p>
   * @param transactionId	the This is a transaction identifier.
   * @param checkoutId	the This is a merchant Checkout identifier.
   * @param cartId	the This is a merchant Cart identifier.
   * @return 	the PaymentData.
   */
     public static PaymentData show(String transactionId, QueryParams queryParams){
			return show( transactionId,  queryParams, MasterCardApiConfig.config());
            
	}
 
 
 /**
   * PaymentData Service
   * <p>This service is used to retrieve the consumer&#39;s payment, shipping address, and recipient personal information from Masterpass.</p>
   * @param transactionId	the This is a transaction identifier.
   * @param checkoutId	the This is a merchant Checkout identifier.
   * @param cartId	the This is a merchant Cart identifier.
   * @param apiConfig  the ApiConfig object for multiple environment configuration 
   * @return 	the PaymentData.
   */
     public static PaymentData show(String transactionId, QueryParams queryParams, ApiConfig apiConfig){
   
	 String path = "/masterpass/paymentdata/{transactionId}";
	 ServiceRequest serviceRequest = new ServiceRequest();	
	 serviceRequest.pathParam("transactionId",transactionId);
	 
	 
	 
	 serviceRequest.queryParams(queryParams);
	 serviceRequest.contentType("application/json");
	 
	 ApiClient apiClient = new ApiClient(apiConfig);
     apiClient.setApiTracker(new APITrackerImpl());
	 apiClient.setErrorHandler(new MasterpassErrorHandler());
	 
	 return apiClient.call(path,serviceRequest,"GET",PaymentData.class);
     
	}
 
}
