package com.mastercard.merchant.checkout.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains different methods to send transaction details to Masterpass using PostbackApi.
 **/
@Root(name = "Postback")
@XmlRootElement (name = "Postback")
public class Postback   {
  
  @SerializedName("transactionId")
  @Element(name = "transactionId")
  private String transactionId = null;
  
  @SerializedName("currency")
  @Element(name = "currency")
  private String currency = null;
  
  @SerializedName("amount")
  @Element(name = "amount")
  private Double amount = null;
  
  @SerializedName("paymentSuccessful")
  @Element(name = "paymentSuccessful")
  private Boolean paymentSuccessful = null;
  
  @SerializedName("paymentCode")
  @Element(name = "paymentCode")
  private String paymentCode = null;
  
  @SerializedName("paymentDate")
  @Element(name = "paymentDate")
  private Date paymentDate = null;
  
  
  /**
   * Gets the transaction Id.
   * 
   * @return	the transaction Id.
   **/
  @XmlElement(name = "transactionId")
  public String getTransactionId() {
    return transactionId;
  }
  
  /**
  * Sets the transaction Id.
  *
  * @param transactionId the transaction Id.
  */
    public Postback transactionId(String transactionId) {
    this.transactionId = transactionId;
    return this;
  }
  
  
    

  
  /**
   * Gets the currency for the transaction; for example, USD.
   * 
   * @return	the currency for the transaction; for example, USD.
   **/
  @XmlElement(name = "currency")
  public String getCurrency() {
    return currency;
  }
  
  /**
  * Sets the currency for the transaction; for example, USD.
  *
  * @param currency the currency for the transaction; for example, USD.
  */
    public Postback currency(String currency) {
    this.currency = currency;
    return this;
  }
  
  
    

  
  /**
   * Gets the transaction order amount.
   * 
   * @return	the transaction order amount.
   **/
  @XmlElement(name = "amount")
  public Double getAmount() {
    return amount;
  }
  
  /**
  * Sets the transaction order amount.
  *
  * @param amount the transaction order amount.
  */
    public Postback amount(Double amount) {
    this.amount = amount;
    return this;
  }
  
  
    

  
  /**
   * Gets the payment status indicator. It is set to true if payment successful with PSP else false.
   * 
   * @return	the payment status indicator. It is set to true if payment successful with PSP else false.
   **/
  @XmlElement(name = "paymentSuccessful")
  public Boolean getPaymentSuccessful() {
    return paymentSuccessful;
  }
  
  /**
  * Sets the payment status indicator. It is set to true if payment successful with PSP else false.
  *
  * @param paymentSuccessful the payment status indicator. It is set to true if payment successful with PSP else false.
  */
    public Postback paymentSuccessful(Boolean paymentSuccessful) {
    this.paymentSuccessful = paymentSuccessful;
    return this;
  }
  
  
    

  
  /**
   * Gets the six-digit approval code returned by payment API.
   * 
   * @return	the six-digit approval code returned by payment API.
   **/
  @XmlElement(name = "paymentCode")
  public String getPaymentCode() {
    return paymentCode;
  }
  
  /**
  * Sets the six-digit approval code returned by payment API.
  *
  * @param paymentCode the six-digit approval code returned by payment API.
  */
    public Postback paymentCode(String paymentCode) {
    this.paymentCode = paymentCode;
    return this;
  }
  
  
    

  
  /**
   * Gets the date of purchase.
   * 
   * @return	the date of purchase.
   **/
  @XmlElement(name = "paymentDate")
  public Date getPaymentDate() {
    return paymentDate;
  }
  
  /**
  * Sets the date of purchase.
  *
  * @param paymentDate the date of purchase.
  */
    public Postback paymentDate(Date paymentDate) {
    this.paymentDate = paymentDate;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Postback postback = (Postback) o;
    return Objects.equals(transactionId, postback.transactionId) &&
        Objects.equals(currency, postback.currency) &&
        Objects.equals(amount, postback.amount) &&
        Objects.equals(paymentSuccessful, postback.paymentSuccessful) &&
        Objects.equals(paymentCode, postback.paymentCode) &&
        Objects.equals(paymentDate, postback.paymentDate);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(transactionId, currency, amount, paymentSuccessful, paymentCode, paymentDate);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Postback {\n");
    
    sb.append("    transactionId: ").append(toIndentedString(transactionId)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    paymentSuccessful: ").append(toIndentedString(paymentSuccessful)).append("\n");
    sb.append("    paymentCode: ").append(toIndentedString(paymentCode)).append("\n");
    sb.append("    paymentDate: ").append(toIndentedString(paymentDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


